/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.rendering.operations;

import freemarker.template.TemplateException;
import java.io.IOException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.rendering.RenderingService;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.rendering.api.RenderingException;
import org.nuxeo.runtime.services.resource.ResourceService;

@Operation(id="Render.DocumentFeed", category="Conversion", label="Render Document Feed", description="Get a list of documents as input and outputs a single blob containing the rendering of the document list. The template attribute may contain either the template content either a template URI. Template URis are strings in the form 'template:template_name' and will be located using the runtime resource service. Return the rendered blob")
public class RenderDocumentFeed {
    public static final String ID = "Render.DocumentFeed";
    @Context
    protected ResourceService rs;
    @Context
    protected OperationContext ctx;
    @Param(name="template", widget="TemplateResource")
    protected String template;
    @Param(name="type", widget="Option", required=false, values={"ftl", "mvel"})
    protected String type = "ftl";
    @Param(name="filename", required=false, values={"output.ftl"})
    protected String name = "output.ftl";
    @Param(name="mimetype", required=false, values={"text/xml"})
    protected String mimeType = "text/xml";
    @Param(name="charset", required=false)
    protected String charset = "UTF-8";

    @OperationMethod
    public Blob run(DocumentModelList docs) throws OperationException, RenderingException, TemplateException, IOException {
        try (OperationContext subCtx = this.ctx.getSubContext(true, docs);){
            String content = RenderingService.getInstance().render(this.type, this.template, subCtx);
            Blob blob = Blobs.createBlob((String)content, (String)this.mimeType, (String)this.charset, (String)this.name);
            return blob;
        }
    }
}

