/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.PropertyException;

public class DataModelProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    protected boolean onlyDirtyProperties = false;
    protected Map<String, Serializable> properties = new HashMap<String, Serializable>();

    public DataModelProperties() {
    }

    public DataModelProperties(DataModel dm, boolean onlyDirtyProperties) throws PropertyException {
        this.onlyDirtyProperties = onlyDirtyProperties;
        this.addDataModel(dm);
    }

    public DataModelProperties(List<DataModel> dms, boolean onlyDirtyProperties) throws PropertyException {
        this.onlyDirtyProperties = onlyDirtyProperties;
        for (DataModel dm : dms) {
            this.addDataModel(dm);
        }
    }

    public DataModelProperties(DataModel dm) throws PropertyException {
        this(dm, false);
    }

    public DataModelProperties(List<DataModel> dms) throws PropertyException {
        this(dms, false);
    }

    public void addDataModel(DataModel dm) throws PropertyException {
        for (Map.Entry entry : dm.getMap().entrySet()) {
            Object key = (String)entry.getKey();
            if ((!this.onlyDirtyProperties || !dm.isDirty((String)key)) && this.onlyDirtyProperties) continue;
            if (!((String)key).contains(":")) {
                key = dm.getSchema() + ":" + (String)key;
            }
            this.properties.put((String)key, (Serializable)entry.getValue());
        }
    }

    public Map<String, Serializable> getMap() {
        return this.properties;
    }

    @Override
    public String toString() {
        HashMap<String, Object> merged = new HashMap<String, Object>();
        merged.putAll(this.properties);
        merged.putAll(this);
        return ((Object)merged).toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.properties.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DataModelProperties)) {
            return false;
        }
        DataModelProperties other = (DataModelProperties)obj;
        return this.properties.equals(other.properties);
    }
}

