/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.io.upload.batch.Batch;
import org.nuxeo.ecm.core.io.upload.batch.BatchManager;
import org.nuxeo.ecm.platform.web.common.RequestContext;
import org.nuxeo.runtime.api.Framework;

public class JSONBatchBlobDecoder
implements JSONBlobDecoder {
    @Override
    public Blob getBlobFromJSON(ObjectNode jsonObject) {
        Blob blob = null;
        if (!jsonObject.has("upload-batch")) {
            return null;
        }
        String batchId = jsonObject.get("upload-batch").textValue();
        String fileId = null;
        if (jsonObject.has("upload-fileId")) {
            fileId = jsonObject.get("upload-fileId").textValue();
        }
        if (fileId != null) {
            BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
            Batch batch = bm.getBatch(batchId);
            if (batch == null) {
                return null;
            }
            blob = batch.getBlob(fileId);
            if (RequestContext.getActiveContext() != null) {
                boolean drop;
                boolean bl = drop = !Boolean.parseBoolean(RequestContext.getActiveContext().getRequest().getHeader("X-Batch-No-Drop"));
                if (drop) {
                    HttpServletResponse response = RequestContext.getActiveContext().getResponse();
                    RequestContext.getActiveContext().addRequestCleanupHandler(request -> {
                        if (response.getStatus() >= 400) {
                            return;
                        }
                        BatchManager bm1 = (BatchManager)Framework.getService(BatchManager.class);
                        bm1.clean(batchId);
                    });
                }
            }
        }
        return blob;
    }
}

