/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;

public class LoginStack {
    protected List<Entry> stack = new ArrayList<Entry>();
    protected CoreSession originalSession;
    protected CoreSession currentSession;

    public LoginStack(CoreSession session) {
        this.setSession(session);
    }

    public void setSession(CoreSession session) {
        this.originalSession = session;
        this.currentSession = session;
    }

    public CoreSession getSession() {
        return this.currentSession;
    }

    public void push(LoginContext lc) {
        Entry entry = new Entry(lc);
        String repositoryName = this.originalSession != null ? this.originalSession.getRepositoryName() : null;
        this.currentSession = entry.session = CoreInstance.getCoreSession((String)repositoryName);
        this.stack.add(entry);
    }

    public Entry peek() {
        if (!this.stack.isEmpty()) {
            return this.stack.get(this.stack.size() - 1);
        }
        return null;
    }

    public void pop() {
        if (!this.stack.isEmpty()) {
            Entry entry = this.stack.remove(this.stack.size() - 1);
            entry.dispose();
            entry = this.peek();
            this.currentSession = entry != null ? entry.session : this.originalSession;
        }
    }

    protected void clear() {
        if (!this.stack.isEmpty()) {
            for (int i = this.stack.size() - 1; i > -1; --i) {
                this.stack.get(i).dispose();
            }
            this.stack.clear();
            this.currentSession = this.originalSession;
            this.stack.clear();
        }
    }

    public static class Entry {
        private static final Logger log = LogManager.getLogger(Entry.class);
        public LoginContext lc;
        public CoreSession session;

        public Entry(LoginContext lc) {
            this.lc = lc;
        }

        public final boolean hasSession() {
            return this.session != null;
        }

        public final void dispose() {
            try {
                if (this.session != null) {
                    this.session.save();
                }
            }
            finally {
                try {
                    this.session = null;
                    this.lc.logout();
                    this.lc = null;
                }
                catch (LoginException e) {
                    log.error((Object)e);
                }
            }
        }
    }
}

