/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.AutomationAdmin;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.ChainException;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.TypeAdapter;
import org.nuxeo.ecm.automation.context.ContextHelper;
import org.nuxeo.ecm.automation.context.ContextHelperDescriptor;
import org.nuxeo.ecm.automation.context.ContextService;
import org.nuxeo.ecm.automation.context.ContextServiceImpl;
import org.nuxeo.ecm.automation.core.OperationDescriptor;
import org.nuxeo.ecm.automation.core.events.EventHandler;
import org.nuxeo.ecm.automation.core.events.EventHandlerRegistry;
import org.nuxeo.ecm.automation.core.exception.ChainExceptionFilter;
import org.nuxeo.ecm.automation.core.exception.ChainExceptionImpl;
import org.nuxeo.ecm.automation.core.impl.ChainTypeImpl;
import org.nuxeo.ecm.automation.core.impl.OperationServiceImpl;
import org.nuxeo.ecm.automation.core.impl.TypeAdapterKey;
import org.nuxeo.ecm.automation.core.trace.TracerFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.ServerLocator;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class AutomationComponent
extends DefaultComponent {
    private static final Logger log = LogManager.getLogger(AutomationComponent.class);
    public static final String AUTOMATION_COMPONENT_NAME = "org.nuxeo.ecm.core.operation.OperationServiceComponent";
    public static final String XP_OPERATIONS = "operations";
    public static final String XP_ADAPTERS = "adapters";
    public static final String XP_CHAINS = "chains";
    public static final String XP_EVENT_HANDLERS = "event-handlers";
    public static final String XP_CHAIN_EXCEPTION = "chainException";
    public static final String XP_AUTOMATION_FILTER = "automationFilter";
    public static final String XP_CONTEXT_HELPER = "contextHelpers";
    public static final String XP_INTERNAL_OPERATIONS = "internalOperations";
    protected static final Set<String> RESERVED_CONTEXT_HELPER_IDS = new LinkedHashSet<String>(List.of("CurrentDate", "Context", "ctx", "This", "Session", "CurrentUser", "currentUser", "Env", "Document", "currentDocument", "Documents", "params", "input"));
    protected OperationServiceImpl service;
    protected EventHandlerRegistry handlers;
    protected TracerFactory tracerFactory;
    protected ContextService contextService;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        OperationDescriptor descriptor;
        OperationDescriptor existing;
        if (contribution instanceof OperationDescriptor && (existing = (OperationDescriptor)this.getDescriptor(XP_INTERNAL_OPERATIONS, (descriptor = (OperationDescriptor)contribution).getId())) != null) {
            if (!descriptor.replace()) {
                throw new NuxeoException("An operation is already bound to: " + descriptor.getId() + ". Use 'replace=true' to replace an existing operation");
            }
            if (!descriptor.getClass().equals(existing.getClass())) {
                throw new UnsupportedOperationException("Can't merge operations with id: " + existing.getId() + ". The type " + String.valueOf(descriptor.toType()) + " cannot be merged in " + String.valueOf(existing.toType()) + ".");
            }
        }
        if (XP_OPERATIONS.equals(extensionPoint) || XP_CHAINS.equals(extensionPoint)) {
            super.registerContribution(contribution, XP_INTERNAL_OPERATIONS, contributor);
        }
        super.registerContribution(contribution, extensionPoint, contributor);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP_OPERATIONS.equals(extensionPoint) || XP_CHAINS.equals(extensionPoint)) {
            super.unregisterContribution(contribution, XP_INTERNAL_OPERATIONS, contributor);
        }
        super.unregisterContribution(contribution, extensionPoint, contributor);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == AutomationService.class || adapter == AutomationAdmin.class) {
            return adapter.cast(this.service);
        }
        if (adapter == EventHandlerRegistry.class) {
            return adapter.cast(this.handlers);
        }
        if (adapter == TracerFactory.class) {
            return adapter.cast(this.tracerFactory);
        }
        if (adapter == ContextService.class) {
            return adapter.cast(this.contextService);
        }
        return null;
    }

    public void start(ComponentContext context) {
        Map<String, OperationType> operations = this.getDescriptors(XP_INTERNAL_OPERATIONS).stream().filter(OperationDescriptor::isEnabled).map(OperationDescriptor::toType).mapMulti((operationType, consumer) -> {
            consumer.accept(new OperationTypeWithId(operationType.getId(), (OperationType)operationType));
            for (String alias : ArrayUtils.nullToEmpty((String[])operationType.getAliases())) {
                consumer.accept(new OperationTypeWithId(alias, (OperationType)operationType));
            }
        }).collect(Collectors.toMap(OperationTypeWithId::idOrAlias, OperationTypeWithId::operationType, (operationType1, operationType2) -> {
            throw new NuxeoException("The operation: " + String.valueOf(operationType2) + " is overriding: " + String.valueOf(operationType1) + " with its alias which is not permitted");
        }));
        Map<String, ChainException> chainExceptions = this.getDescriptors(XP_CHAIN_EXCEPTION).stream().map(ChainExceptionImpl::new).collect(Collectors.toMap(ChainExceptionImpl::getId, Function.identity()));
        Map<String, ChainExceptionFilter> filters = this.getDescriptors(XP_AUTOMATION_FILTER).stream().map(ChainExceptionFilter::new).collect(Collectors.toMap(ChainExceptionFilter::getId, Function.identity()));
        Map<TypeAdapterKey, TypeAdapter> adapters = this.getDescriptors(XP_ADAPTERS).stream().collect(Collectors.toMap(descriptor -> new TypeAdapterKey(descriptor.accept, descriptor.produce), descriptor -> {
            try {
                return descriptor.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException("Unable to instantiate adapter", (Throwable)e);
            }
        }));
        Map eventHandlers = this.getDescriptors(XP_EVENT_HANDLERS).stream().filter(EventHandler::isEnabled).collect(Collectors.partitioningBy(EventHandler::isPostCommit, Collectors.flatMapping(handler -> handler.getEvents().stream().map(eventId -> new EventHandlerWithEventId((String)eventId, (EventHandler)handler)), Collectors.groupingBy(EventHandlerWithEventId::eventId, Collectors.mapping(EventHandlerWithEventId::handler, Collectors.toList())))));
        Map<String, ContextHelper> contextHelpers = this.getDescriptors(XP_CONTEXT_HELPER).stream().filter(ContextHelperDescriptor::isEnabled).filter(descriptor -> {
            if (RESERVED_CONTEXT_HELPER_IDS.contains(descriptor.getId())) {
                log.warn("The context helper with id: {} cannot be registered because the id is reserved. Please use another one. The Nuxeo reserved aliases are: {}", (Object)descriptor.getId(), (Object)String.join((CharSequence)",", RESERVED_CONTEXT_HELPER_IDS));
                return false;
            }
            return true;
        }).collect(Collectors.toMap(ContextHelperDescriptor::getId, ContextHelperDescriptor::instantiateContextHelper));
        this.service = new OperationServiceImpl(operations, chainExceptions, filters, adapters);
        this.handlers = new EventHandlerRegistry(eventHandlers.get(Boolean.FALSE), eventHandlers.get(Boolean.TRUE));
        this.tracerFactory = new TracerFactory();
        this.contextService = new ContextServiceImpl(contextHelpers);
        this.checkOperationChains();
        if (!this.tracerFactory.getRecordingState()) {
            log.info("You can activate automation trace mode to get more information on automation executions");
        }
        try {
            this.bindManagement();
        }
        catch (JMException e) {
            throw new RuntimeException("Cannot bind management", e);
        }
    }

    protected void checkOperationChains() {
        for (OperationType operationType : this.service.getOperations()) {
            if (!(operationType instanceof ChainTypeImpl)) continue;
            ChainTypeImpl chainType = (ChainTypeImpl)operationType;
            OperationChain chain = chainType.getChain();
            for (OperationParameters opp : chain.getOperations()) {
                if (this.service.hasOperation(opp.id())) continue;
                String msg = String.format("Operation chain with id '%s' references unknown operation with id '%s'", chain.getId(), opp.id());
                log.error(msg);
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, msg);
            }
        }
    }

    public void stop(ComponentContext context) {
        this.service.flushCompiledChains();
        try {
            this.unBindManagement();
        }
        catch (JMException e) {
            throw new RuntimeException("Cannot unbind management", e);
        }
    }

    protected void bindManagement() throws JMException {
        ObjectName objectName = new ObjectName("org.nuxeo.automation:name=tracerfactory");
        MBeanServer mBeanServer = ((ServerLocator)Framework.getService(ServerLocator.class)).lookupServer();
        mBeanServer.registerMBean(this.tracerFactory, objectName);
    }

    protected void unBindManagement() throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException, InstanceNotFoundException {
        ObjectName on = new ObjectName("org.nuxeo.automation:name=tracerfactory");
        ServerLocator locator = (ServerLocator)Framework.getService(ServerLocator.class);
        if (locator != null) {
            MBeanServer mBeanServer = locator.lookupServer();
            mBeanServer.unregisterMBean(on);
        }
    }

    record EventHandlerWithEventId(String eventId, EventHandler handler) {
    }

    record OperationTypeWithId(String idOrAlias, OperationType operationType) {
    }
}

