/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.events;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Filter;

public class DocumentAttributeFilterFactory {
    public static final String ANY_DOC = "Any";
    public static final String REGULAR_DOC = "Regular Document";
    public static final String LINK_DOC = "Document Link";
    public static final String PUBLISHED_DOC = "Published Document";
    public static final String PROXY_DOC = "Document Proxy";
    public static final String VERSION_DOC = "Document Version";
    public static final String IMMUTABLE_DOC = "Immutable Document";
    public static final String MUTABLE_DOC = "Mutable Document";
    protected static final Map<String, Filter> filters = new HashMap<String, Filter>();

    private DocumentAttributeFilterFactory() {
    }

    public static Filter getFilter(String attr) {
        return filters.get(attr);
    }

    static {
        filters.put(REGULAR_DOC, new RegularDocFilter());
        filters.put(LINK_DOC, new LinkDocFilter());
        filters.put(PUBLISHED_DOC, new PublishedDocFilter());
        filters.put(PROXY_DOC, new ProxyDocFilter());
        filters.put(VERSION_DOC, new VersionDocFilter());
        filters.put(IMMUTABLE_DOC, new ImmutableDocFilter());
        filters.put(MUTABLE_DOC, new MutableDocFilter());
    }

    static class RegularDocFilter
    implements Filter {
        RegularDocFilter() {
        }

        public boolean accept(DocumentModel doc) {
            return !doc.isImmutable() && !doc.isProxy();
        }
    }

    static class LinkDocFilter
    implements Filter {
        LinkDocFilter() {
        }

        public boolean accept(DocumentModel doc) {
            return !doc.isImmutable() && doc.isProxy();
        }
    }

    static class PublishedDocFilter
    implements Filter {
        PublishedDocFilter() {
        }

        public boolean accept(DocumentModel doc) {
            return doc.isImmutable() && doc.isProxy();
        }
    }

    static class ProxyDocFilter
    implements Filter {
        ProxyDocFilter() {
        }

        public boolean accept(DocumentModel doc) {
            return doc.isProxy();
        }
    }

    static class VersionDocFilter
    implements Filter {
        VersionDocFilter() {
        }

        public boolean accept(DocumentModel doc) {
            return doc.isVersion();
        }
    }

    static class ImmutableDocFilter
    implements Filter {
        ImmutableDocFilter() {
        }

        public boolean accept(DocumentModel doc) {
            return doc.isImmutable();
        }
    }

    static class MutableDocFilter
    implements Filter {
        MutableDocFilter() {
        }

        public boolean accept(DocumentModel doc) {
            return !doc.isImmutable();
        }
    }
}

