/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.AutomationAdmin;
import org.nuxeo.ecm.automation.AutomationFilter;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.ChainException;
import org.nuxeo.ecm.automation.CompiledChain;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.TypeAdapter;
import org.nuxeo.ecm.automation.core.OperationChainContribution;
import org.nuxeo.ecm.automation.core.exception.CatchChainException;
import org.nuxeo.ecm.automation.core.exception.ChainExceptionFilter;
import org.nuxeo.ecm.automation.core.impl.AdapterKeyedRegistry;
import org.nuxeo.ecm.automation.core.impl.ChainTypeImpl;
import org.nuxeo.ecm.automation.core.impl.OperationChainCompiler;
import org.nuxeo.ecm.automation.core.impl.TypeAdapterKey;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class OperationServiceImpl
implements AutomationService,
AutomationAdmin {
    private static final Logger log = LogManager.getLogger(OperationServiceImpl.class);
    public static final String EXPORT_ALIASES_CONFIGURATION_PARAM = "nuxeo.automation.export.aliases";
    protected final Map<String, OperationType> operations;
    protected final Map<String, ChainException> chainExceptions;
    protected final Map<String, ChainExceptionFilter> filters;
    protected final AdapterKeyedRegistry adapters;
    protected final OperationChainCompiler compiler = new OperationChainCompiler(this);

    public OperationServiceImpl(Map<String, OperationType> operations, Map<String, ChainException> chainExceptions, Map<String, ChainExceptionFilter> filters, Map<TypeAdapterKey, ? extends TypeAdapter> adapters) {
        this.operations = operations;
        this.chainExceptions = chainExceptions;
        this.filters = filters;
        this.adapters = new AdapterKeyedRegistry((Map<? extends TypeAdapterKey, ? extends TypeAdapter>)adapters);
    }

    @Override
    public Object run(OperationContext ctx, String operationId) throws OperationException {
        return this.run(ctx, this.getOperationChain(operationId));
    }

    @Override
    public Object run(OperationContext ctx, String operationId, Map<String, ?> args) throws OperationException {
        OperationType op = this.operations.get(operationId);
        if (op == null) {
            throw new IllegalArgumentException("No such operation " + operationId);
        }
        if (args == null) {
            log.warn("null operation parameters given for {}", (Object)operationId, (Object)new Throwable("stack trace"));
            args = Collections.emptyMap();
        }
        return ctx.callWithChainParameters(() -> this.run(ctx, this.getOperationChain(operationId)), args);
    }

    @Override
    public Object run(OperationContext ctx, OperationChain chain) throws OperationException {
        Object input = ctx.getInput();
        Class<Void> inputType = input == null ? Void.TYPE : input.getClass();
        CompiledChain compiled = this.compileChain(inputType, chain);
        boolean completedAbruptly = true;
        try {
            Object result = compiled.invoke(ctx);
            completedAbruptly = false;
            Object object = result;
            return object;
        }
        catch (OperationException cause) {
            completedAbruptly = false;
            if (this.hasChainException(chain.getId())) {
                Object object = this.run(ctx, this.getChainExceptionToRun(ctx, chain.getId(), cause));
                return object;
            }
            throw cause;
        }
        finally {
            if (completedAbruptly) {
                ctx.setRollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object runInNewTx(OperationContext ctx, String chainId, Map<String, ?> chainParameters, Integer timeout, boolean rollbackGlobalOnError) throws OperationException {
        Object result = null;
        if (TransactionHelper.isTransactionMarkedRollback()) {
            return null;
        }
        TransactionHelper.commitOrRollbackTransaction();
        int to = timeout == null ? 0 : timeout;
        TransactionHelper.startTransaction((int)to);
        boolean ok = false;
        try {
            result = this.run(ctx, chainId, chainParameters);
            ok = true;
        }
        catch (OperationException e) {
            if (rollbackGlobalOnError) {
                throw e;
            }
            log.error("Error while executing operation " + chainId, (Throwable)e);
        }
        finally {
            if (!ok) {
                TransactionHelper.setTransactionRollbackOnly();
            }
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
        return result;
    }

    protected String getChainExceptionToRun(OperationContext ctx, String operationTypeId, OperationException oe) throws OperationException {
        ctx.put("Exception", (Object)oe.getClass().getSimpleName());
        ctx.put("exceptionName", (Object)oe.getClass().getSimpleName());
        ctx.put("exceptionObject", (Object)oe);
        ChainException chainException = this.getChainException(operationTypeId);
        CatchChainException catchChainException = new CatchChainException();
        for (CatchChainException catchChainExceptionItem : chainException.getCatchChainExceptions()) {
            if (catchChainExceptionItem.hasFilter().booleanValue()) {
                AutomationFilter filter = this.getAutomationFilter(catchChainExceptionItem.getFilterId());
                try {
                    String filterValue = (String)filter.getValue().eval(ctx);
                    if (!Boolean.parseBoolean(filterValue)) continue;
                    catchChainException = this.getCatchChainExceptionByPriority(catchChainException, catchChainExceptionItem);
                    continue;
                }
                catch (RuntimeException e) {
                    throw new OperationException("Cannot evaluate Automation Filter " + filter.getId() + " mvel expression.", e);
                }
            }
            catchChainException = this.getCatchChainExceptionByPriority(catchChainException, catchChainExceptionItem);
        }
        String chainId = catchChainException.getChainId();
        if (chainId.isEmpty()) {
            throw new OperationException("No chain exception has been selected to be run. You should verify Automation filters applied.");
        }
        if (catchChainException.getRollBack().booleanValue()) {
            ctx.setRollback();
        }
        return catchChainException.getChainId();
    }

    protected CatchChainException getCatchChainExceptionByPriority(CatchChainException catchChainException, CatchChainException catchChainExceptionItem) {
        return catchChainException.getPriority() <= catchChainExceptionItem.getPriority() ? catchChainExceptionItem : catchChainException;
    }

    public static OperationParameters[] toParams(String ... ids) {
        OperationParameters[] operationParameters = new OperationParameters[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            operationParameters[i] = new OperationParameters(ids[i]);
        }
        return operationParameters;
    }

    protected OperationChain getOperationChain(String id) throws OperationNotFoundException {
        OperationType type = this.getOperation(id);
        if (type instanceof ChainTypeImpl) {
            return ((ChainTypeImpl)type).chain;
        }
        OperationChain chain = new OperationChain(id);
        chain.add(id);
        return chain;
    }

    @Override
    public synchronized void flushCompiledChains() {
        this.compiler.cache.invalidateAll();
    }

    @Override
    public OperationType[] getOperations() {
        return (OperationType[])new HashSet<OperationType>(this.operations.values()).toArray(OperationType[]::new);
    }

    @Override
    public OperationType getOperation(String id) throws OperationNotFoundException {
        OperationType op = this.operations.get(id);
        if (op == null) {
            throw new OperationNotFoundException("No operation was bound on ID: " + id);
        }
        return op;
    }

    @Override
    public boolean hasOperation(String id) {
        OperationType op = this.operations.get(id);
        return op != null;
    }

    @Override
    public CompiledChain compileChain(Class<?> inputType, OperationParameters ... ops) throws OperationException {
        return this.compileChain(inputType, new OperationChain("", List.of(ops)));
    }

    @Override
    public CompiledChain compileChain(Class<?> inputType, OperationChain chain) throws OperationException {
        ChainTypeImpl chainType = new ChainTypeImpl(chain, OperationChainContribution.contribOf(chain, false), null);
        return this.compiler.compile(chainType, inputType);
    }

    @Override
    public TypeAdapter getTypeAdapter(Class<?> accept, Class<?> produce) {
        return (TypeAdapter)this.adapters.get(new TypeAdapterKey(accept, produce));
    }

    @Override
    public boolean isTypeAdaptable(Class<?> typeToAdapt, Class<?> targetType) {
        return this.getTypeAdapter(typeToAdapt, targetType) != null;
    }

    @Override
    public <T> T getAdaptedValue(OperationContext ctx, Object toAdapt, Class<?> targetType) throws OperationException {
        Class toAdaptClass;
        if (targetType.isAssignableFrom(Void.class)) {
            return null;
        }
        if (OperationContext.class.isAssignableFrom(targetType)) {
            return (T)ctx;
        }
        Class clazz = toAdaptClass = toAdapt == null ? Void.class : toAdapt.getClass();
        if (targetType.isPrimitive() && (targetType = OperationServiceImpl.getTypeForPrimitive(targetType)).isAssignableFrom(toAdaptClass)) {
            return (T)toAdapt;
        }
        if (targetType.isArray() && toAdapt instanceof List) {
            Iterable iterable = (Iterable)toAdapt;
            return (T)Iterables.toArray((Iterable)iterable, targetType.getComponentType());
        }
        TypeAdapter adapter = this.getTypeAdapter(toAdaptClass, targetType);
        if (adapter == null) {
            if (toAdapt == null) {
                return null;
            }
            if (toAdapt instanceof JsonNode) {
                ObjectMapper mapper = new ObjectMapper();
                return (T)mapper.convertValue(toAdapt, targetType);
            }
            if (targetType.isAssignableFrom(OperationContext.class)) {
                return (T)ctx;
            }
            throw new OperationException("No type adapter found for input: " + String.valueOf(toAdaptClass) + " and output " + String.valueOf(targetType));
        }
        return (T)adapter.getAdaptedValue(ctx, toAdapt);
    }

    @Override
    public List<OperationDocumentation> getDocumentation() throws OperationException {
        ArrayList<OperationDocumentation> result = new ArrayList<OperationDocumentation>();
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        boolean exportAliases = configurationService.isBooleanTrue(EXPORT_ALIASES_CONFIGURATION_PARAM);
        for (OperationType ot : new HashSet<OperationType>(this.operations.values())) {
            try {
                OperationDocumentation documentation = ot.getDocumentation();
                result.add(documentation);
                Object[] aliases = ot.getAliases();
                if (!exportAliases || !ArrayUtils.isNotEmpty((Object[])aliases)) continue;
                for (Object alias : aliases) {
                    result.add(OperationDocumentation.copyForAlias(documentation, (String)alias));
                }
            }
            catch (OperationNotFoundException operationNotFoundException) {
            }
        }
        Collections.sort(result);
        return result;
    }

    public static Class<?> getTypeForPrimitive(Class<?> primitiveType) {
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        return primitiveType;
    }

    @Override
    public ChainException[] getChainExceptions() {
        return (ChainException[])this.chainExceptions.values().toArray(ChainException[]::new);
    }

    @Override
    public ChainException getChainException(String onChainId) {
        return this.chainExceptions.values().stream().filter(chainException -> onChainId.equals(chainException.getOnChainId())).findFirst().orElse(null);
    }

    @Override
    public boolean hasChainException(String onChainId) {
        return this.chainExceptions.values().stream().anyMatch(chainException -> onChainId.equals(chainException.getOnChainId()));
    }

    @Override
    public AutomationFilter getAutomationFilter(String id) {
        return this.filters.get(id);
    }

    @Override
    public AutomationFilter[] getAutomationFilters() {
        return (AutomationFilter[])this.filters.values().toArray(AutomationFilter[]::new);
    }
}

