/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OutputCollector;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.impl.AbstractOperationType;
import org.nuxeo.ecm.automation.core.impl.InvokableIteratorMethod;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.runtime.api.Framework;

public class OperationTypeImpl
extends AbstractOperationType {
    protected String id;
    protected String[] aliases;
    protected Class<?> type;
    protected String contributingComponent;
    protected List<InvokableMethod> methods;
    protected Map<String, Field> params;
    protected List<Field> injectableFields;

    public OperationTypeImpl(String id, Class<?> type, String contributingComponent) {
        Operation anno = type.getAnnotation(Operation.class);
        if (anno == null) {
            throw new IllegalArgumentException("Invalid operation class: " + String.valueOf(type) + ". No @Operation annotation found on class.");
        }
        this.id = id;
        this.aliases = anno.aliases();
        this.type = type;
        this.contributingComponent = contributingComponent;
        this.methods = OperationTypeImpl.initMethods(this, type);
        this.params = OperationTypeImpl.initParams(type);
        this.injectableFields = OperationTypeImpl.initFields(type);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public OperationDocumentation getDocumentation() {
        Operation op = this.type.getAnnotation(Operation.class);
        OperationDocumentation doc = new OperationDocumentation(op.id());
        doc.label = op.label();
        doc.requires = op.requires();
        doc.category = op.category();
        doc.since = op.since();
        doc.deprecatedSince = op.deprecatedSince();
        doc.addToStudio = op.addToStudio();
        doc.setAliases(op.aliases());
        doc.implementationClass = this.type.getName();
        if (doc.requires.isEmpty()) {
            doc.requires = null;
        }
        if (doc.label.isEmpty()) {
            doc.label = doc.id;
        }
        doc.description = op.description();
        LinkedList<OperationDocumentation.Param> paramsAccumulator = new LinkedList<OperationDocumentation.Param>();
        for (Field field : this.params.values()) {
            Param p = field.getAnnotation(Param.class);
            OperationDocumentation.Param param = new OperationDocumentation.Param();
            param.name = p.name();
            param.description = p.description();
            param.type = this.getParamDocumentationType(field.getType());
            param.widget = p.widget();
            if (param.widget.isEmpty()) {
                param.widget = null;
            }
            param.order = p.order();
            param.values = p.values();
            param.required = p.required();
            paramsAccumulator.add(param);
        }
        Collections.sort(paramsAccumulator);
        doc.params = (OperationDocumentation.Param[])paramsAccumulator.toArray(OperationDocumentation.Param[]::new);
        doc.signature = (String[])this.buildSignature(this.methods, InvokableMethod::getOutputType).toArray(String[]::new);
        return doc;
    }

    @Override
    public String getContributingComponent() {
        return this.contributingComponent;
    }

    @Override
    public InvokableMethod[] getMethodsMatchingInput(Class<?> in) {
        return (InvokableMethod[])this.methods.stream().map(method -> new Match((InvokableMethod)method, method.inputMatch(in))).filter(match -> match.priority > 0).sorted().map(match -> match.method).toArray(InvokableMethod[]::new);
    }

    @Override
    public List<InvokableMethod> getMethods() {
        return this.methods;
    }

    @Override
    public Object newInstance(OperationContext ctx, Map<String, Object> args) throws OperationException {
        Object obj;
        try {
            obj = this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new OperationException(e);
        }
        this.inject(ctx, args, obj);
        return obj;
    }

    public void inject(OperationContext ctx, Map<String, ?> args, Object target) throws OperationException {
        Object obj;
        AutomationService automationService = (AutomationService)Framework.getService(AutomationService.class);
        for (Map.Entry<String, Field> entry : this.params.entrySet()) {
            String[] entryAliases;
            obj = this.resolveObject(ctx, entry.getKey(), args);
            if (obj == null && (entryAliases = entry.getValue().getAnnotation(Param.class).alias()) != null) {
                String alias;
                String[] stringArray = entry.getValue().getAnnotation(Param.class).alias();
                int n = stringArray.length;
                for (int i = 0; i < n && (obj = this.resolveObject(ctx, alias = stringArray[i], args)) == null; ++i) {
                }
            }
            if (obj == null) {
                if (!entry.getValue().getAnnotation(Param.class).required()) continue;
                throw new OperationException("Failed to inject parameter '" + entry.getKey() + "'. Seems it is missing from the context. Operation: " + this.getId());
            }
            Field field = entry.getValue();
            Class<?> cl = obj.getClass();
            if (!field.getType().isAssignableFrom(cl)) {
                obj = automationService.getAdaptedValue(ctx, obj, field.getType());
            }
            try {
                field.set(target, obj);
            }
            catch (ReflectiveOperationException e) {
                throw new OperationException(e);
            }
        }
        for (Field field : this.injectableFields) {
            obj = ctx.getAdapter(field.getType());
            try {
                field.set(target, obj);
            }
            catch (ReflectiveOperationException e) {
                throw new OperationException(e);
            }
        }
    }

    protected Object resolveObject(OperationContext ctx, String key, Map<String, ?> args) {
        Object obj = args.get(key);
        if (obj != null) {
            return ctx.resolve(obj);
        }
        return ctx.getChainParameter(key);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append(this.type).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OperationTypeImpl)) {
            return false;
        }
        OperationTypeImpl ot = (OperationTypeImpl)obj;
        return this.id.equals(ot.getId()) && this.type.equals(ot.type);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("type", (Object)this.type.getName()).append("params", this.params).toString();
    }

    protected static Map<String, Field> initParams(Class<?> type) {
        HashMap<String, Field> params = new HashMap<String, Field>();
        for (Field field : type.getDeclaredFields()) {
            Param param = field.getAnnotation(Param.class);
            if (param == null) continue;
            field.setAccessible(true);
            params.put(param.name(), field);
        }
        return params;
    }

    protected static List<InvokableMethod> initMethods(OperationTypeImpl operationType, Class<?> type) {
        return Stream.of(type.getMethods()).filter(method -> method.isAnnotationPresent(OperationMethod.class)).mapMulti((method, consumer) -> {
            OperationMethod annotation = method.getAnnotation(OperationMethod.class);
            consumer.accept(new InvokableMethod(operationType, (Method)method, annotation));
            if (annotation.collector() != OutputCollector.class) {
                consumer.accept(new InvokableIteratorMethod(operationType, (Method)method, annotation));
            }
        }).sorted().toList();
    }

    protected static List<Field> initFields(Class<?> type) {
        ArrayList<Field> injectableFields = new ArrayList<Field>();
        for (Field field : type.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Context.class)) continue;
            field.setAccessible(true);
            injectableFields.add(field);
        }
        return injectableFields;
    }

    protected static class Match
    implements Comparable<Match> {
        protected InvokableMethod method;
        protected int priority;

        protected Match(InvokableMethod method, int priority) {
            this.method = method;
            this.priority = priority;
        }

        @Override
        public int compareTo(Match o) {
            return o.priority - this.priority;
        }

        public String toString() {
            return "Match(" + String.valueOf(this.method) + ", " + this.priority + ")";
        }
    }
}

