/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.mail;

import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.nuxeo.mail.MailException;
import org.nuxeo.mail.MailMessage;
import org.nuxeo.mail.MailService;
import org.nuxeo.mail.MailSessionBuilder;
import org.nuxeo.runtime.api.Framework;

@Deprecated(since="2023.4")
public class Mailer {
    protected Properties config;
    protected volatile Session session;
    @Deprecated(since="11.1")
    protected Authenticator auth;
    protected final String sessionName;

    @Deprecated(since="11.1")
    public Mailer() {
        this(null, new Properties());
    }

    public Mailer(Properties config) {
        this(null, config);
    }

    public Mailer(String sessionName) {
        this(sessionName, new Properties());
    }

    public Mailer(String sessionName, Properties config) {
        this.config = config;
        this.sessionName = sessionName;
        final String user = config.getProperty("mail.smtp.user");
        final String pass = config.getProperty("mail.smtp.password");
        if (user != null && pass != null) {
            this.auth = new Authenticator(this){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, pass);
                }
            };
        }
    }

    public void setServer(String host) {
        this.setServer(host, "25", false);
    }

    public void setServer(String host, boolean ssl) {
        this.setServer(host, ssl ? "465" : "25", ssl);
    }

    public void setServer(String host, String port) {
        this.setServer(host, port, false);
    }

    public void setServer(String host, String port, boolean ssl) {
        if (ssl) {
            if (port == null) {
                port = "465";
            }
            this.config.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            this.config.put("mail.smtp.ssl.checkserveridentity", "true");
            this.config.put("mail.smtp.socketFactory.fallback", "false");
            this.config.put("mail.smtp.socketFactory.port", port);
        } else if (port == null) {
            port = "25";
        }
        this.config.setProperty("mail.smtp.host", host);
        this.config.setProperty("mail.smtp.port", port);
        this.session = null;
    }

    @Deprecated(since="11.1")
    public void setCredentials(final String user, final String pass) {
        this.config.setProperty("mail.smtp.auth", "true");
        this.config.setProperty("mail.smtp.user", user);
        this.config.setProperty("mail.smtp.password", user);
        this.auth = new Authenticator(this){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, pass);
            }
        };
        this.session = null;
    }

    @Deprecated(since="11.1")
    public void setAuthenticator(Authenticator auth) {
        this.config.setProperty("mail.smtp.auth", "true");
        this.auth = auth;
        this.session = null;
    }

    public void setDebug(boolean debug) {
        this.config.setProperty("mail.debug", Boolean.toString(debug));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession() {
        if (this.session == null) {
            Mailer mailer = this;
            synchronized (mailer) {
                if (this.session == null) {
                    this.session = this.sessionName != null ? MailSessionBuilder.fromJndi((String)this.sessionName).fallbackOn(this.config).build() : MailSessionBuilder.fromProperties((Properties)this.config).build();
                }
            }
        }
        return this.session;
    }

    public Properties getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Properties config) {
        this.config = config;
    }

    public void loadConfiguration(InputStream in) throws IOException {
        this.config.load(in);
    }

    public void send(MimeMessage message) throws MessagingException {
        Transport.send((jakarta.mail.Message)message);
    }

    public Message newMessage() {
        return new Message(this.getSession());
    }

    public void sendEmail(String from, String to, String subject, String body) throws MessagingException {
        MailMessage message = new MailMessage.Builder(to, new String[0]).from(from, new String[0]).subject(subject).content((Object)body).build();
        ((MailService)Framework.getService(MailService.class)).sendMail(message);
    }

    public static class Message
    extends MimeMessage {
        public Message(Session session) {
            super(session);
        }

        public Message(Session session, InputStream in) throws MessagingException {
            super(session, in);
        }

        public Message addTo(String to) throws MessagingException {
            this.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            return this;
        }

        public Message addCc(String cc) throws MessagingException {
            this.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(cc));
            return this;
        }

        public Message addBcc(String bcc) throws MessagingException {
            this.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bcc));
            return this;
        }

        public Message addFrom(String from) throws MessagingException {
            this.addFrom((Address[])new InternetAddress[]{new InternetAddress(from)});
            return this;
        }

        public void addInfoInMessageHeader(String address, AS as) throws MessagingException {
            switch (as.ordinal()) {
                case 0: {
                    this.addFrom(address);
                    break;
                }
                case 1: {
                    this.addTo(address);
                    break;
                }
                case 2: {
                    this.addCc(address);
                    break;
                }
                case 3: {
                    this.addBcc(address);
                    break;
                }
                case 4: {
                    Address[] oldValue = this.getReplyTo();
                    Address[] replyToValue = this.getReplyTo() == null ? new Address[1] : new Address[oldValue.length + 1];
                    for (int i = 0; i < oldValue.length; ++i) {
                        replyToValue[i] = oldValue[i];
                    }
                    replyToValue[oldValue.length] = new InternetAddress(address);
                    this.setReplyTo(replyToValue);
                    break;
                }
                default: {
                    throw new MessagingException("Unknown header info " + as.toString());
                }
            }
        }

        public void setFrom(String from) throws MessagingException {
            this.setFrom((Address)new InternetAddress(from));
        }

        public void send() throws MessagingException {
            ((MailService)Framework.getService(MailService.class)).sendMail(this.fromMimeMessage(this));
        }

        protected MailMessage fromMimeMessage(MimeMessage original) {
            try {
                String subject = null;
                String subjectCharset = null;
                String subjectHeader = original.getSubject();
                if (subjectHeader != null) {
                    String[] details = subjectHeader.split(";");
                    subject = details[0];
                    if (details.length > 1) {
                        subjectCharset = details[1];
                    }
                }
                List<String> mimeTos = this.asStringList(original.getRecipients(MimeMessage.RecipientType.TO));
                return new MailMessage.Builder(mimeTos).from(this.asStringList(original.getFrom())).cc(this.asStringList(original.getRecipients(MimeMessage.RecipientType.CC))).bcc(this.asStringList(original.getRecipients(MimeMessage.RecipientType.BCC))).replyTo(this.asStringList(original.getReplyTo())).date(original.getSentDate()).subject(subject, subjectCharset).content(original.getContent(), original.getContentType()).build();
            }
            catch (MessagingException | IOException e) {
                throw new MailException("Could not read mail content", e);
            }
        }

        protected List<String> asStringList(Object[] objects) {
            return objects == null ? List.of() : Arrays.stream(objects).map(Object::toString).toList();
        }

        public static enum AS {
            FROM,
            TO,
            CC,
            BCC,
            REPLYTO;

        }
    }
}

