/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.schema.types.ListType;

@Operation(id="Document.RemoveItemFromListProperty", category="Document", label="Removes an Entry From a Multivalued Property", description="This operation removes an entry from a multivalued property, specified using a xpath (e.g.: contract:customers). A specific entry can be removed using its index number. If the index parameter is left empty, all entries in the property are removed. Activating the save parameter forces the changes to be written in database immediately (at the cost of performance loss), otherwise changes made to the document will be written in bulk when the chain succeeds. <p>Save parameter has to be turned off when this operation is used in the context of the empty document created, about to create, before document modification, document modified events.</p>")
public class RemoveItemFromListProperty {
    public static final String ID = "Document.RemoveItemFromListProperty";
    @Context
    protected CoreSession session;
    @Context
    protected AutomationService service;
    @Context
    protected OperationContext ctx;
    @Param(name="xpath")
    protected String xpath;
    @Param(name="index", required=false)
    protected Integer index;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws OperationException {
        Property property = doc.getProperty(this.xpath);
        if (!property.isList()) {
            throw new OperationException(String.format("Property: %s of type: %s is not supported by this operation", this.xpath, property.getType().getName()));
        }
        ListType listType = (ListType)property.getType();
        if (listType.isArray()) {
            this.removeItemFromArrayProperty(doc, property);
        } else {
            this.removeItemFromListProperty(property);
        }
        if (this.save) {
            doc = this.session.saveDocument(doc);
        }
        return doc;
    }

    protected void removeItemFromArrayProperty(DocumentModel doc, Property property) {
        if (this.index != null) {
            Serializable[] value = (Serializable[])property.getValue();
            ArrayList<Serializable> list = new ArrayList<Serializable>(Arrays.asList(value));
            list.remove(this.index);
            doc.setPropertyValue(this.xpath, (Serializable)list);
        } else {
            doc.setPropertyValue(this.xpath, null);
        }
    }

    protected void removeItemFromListProperty(Property property) {
        ListProperty listProperty = (ListProperty)property;
        if (this.index != null) {
            listProperty.remove(this.index.intValue());
        } else {
            listProperty.clear();
        }
    }
}

