/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.execution;

import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;

@Operation(id="RunOperation", category="Execution Flow", label="Run Chain", description="Run an operation chain in the current context. The 'parameters' injected are accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.", aliases={"Context.RunOperation"})
public class RunOperation {
    public static final String ID = "RunOperation";
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;
    @Param(name="id")
    protected String chainId;
    @Param(name="isolate", required=false, values={"false"})
    protected boolean isolate = false;
    @Param(name="parameters", description="Accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.", required=false)
    protected Properties chainParameters = new Properties();

    @OperationMethod
    public void run() throws OperationException {
        try (OperationContext subctx = this.ctx.getSubContext(this.isolate, this.ctx.getInput());){
            this.service.run(subctx, this.chainId, this.chainParameters);
        }
    }
}

