/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.scripting;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.schema.DocumentType;

public class DocumentWrapper
extends HashMap<String, Serializable> {
    private static final long serialVersionUID = 1L;
    protected final CoreSession session;
    protected final DocumentModel doc;

    public DocumentWrapper(CoreSession session, DocumentModel doc) {
        this.session = session;
        this.doc = doc;
    }

    public DocumentModel getDoc() {
        return this.doc;
    }

    public CoreSession getSession() {
        return this.session;
    }

    public DocumentWrapper getParent() {
        DocumentModel parent = this.session.getParentDocument(this.doc.getRef());
        return parent != null ? new DocumentWrapper(this.session, parent) : null;
    }

    public DocumentWrapper getParent(String type) {
        DocumentModel parent = this.session.getParentDocument(this.doc.getRef());
        while (parent != null && !type.equals(parent.getType())) {
            parent = this.session.getParentDocument(parent.getRef());
        }
        if (parent == null) {
            return null;
        }
        return new DocumentWrapper(this.session, parent);
    }

    public DocumentWrapper getWorkspace() {
        return this.getParent("Workspace");
    }

    public DocumentWrapper getDomain() {
        return this.getParent("Domain");
    }

    public String getTitle() {
        return this.doc.getTitle();
    }

    public String getPath() {
        return this.doc.getPathAsString();
    }

    public String resolvePath(String relative) {
        return this.doc.getPath().append(relative).toString();
    }

    public DocumentRef getRef() {
        return this.doc.getRef();
    }

    public DocumentRef resolvePathAsRef(String relative) {
        return new PathRef(this.doc.getPath().append(relative).toString());
    }

    public String getDescription() {
        return (String)((Object)this.doc.getPropertyValue("dc:description"));
    }

    public boolean hasFacet(String facet) {
        return this.doc.hasFacet(facet);
    }

    public boolean hasSchema(String schema) {
        return this.doc.hasSchema(schema);
    }

    public boolean addFacet(String facet) {
        return this.doc.addFacet(facet);
    }

    public boolean removeFacet(String facet) {
        return this.doc.removeFacet(facet);
    }

    public String getType() {
        return this.doc.getType();
    }

    public DocumentType getDocumentType() {
        return this.doc.getDocumentType();
    }

    public String getLifeCycle() {
        return this.doc.getCurrentLifeCycleState();
    }

    public boolean isLocked() {
        return this.doc.isLocked();
    }

    public boolean isFolder() {
        return this.doc.isFolder();
    }

    public boolean isImmutable() {
        return this.doc.isImmutable();
    }

    public boolean isProxy() {
        return this.doc.isProxy();
    }

    public boolean isVersion() {
        return this.doc.isVersion();
    }

    public boolean isDownloadable() {
        return this.doc.isDownloadable();
    }

    public boolean isVersionable() {
        return this.doc.isVersionable();
    }

    public boolean isTrashed() {
        return this.doc.isTrashed();
    }

    public String getId() {
        return this.doc.getId();
    }

    public String getName() {
        return this.doc.getName();
    }

    public String[] getSchemas() {
        return this.doc.getSchemas();
    }

    public Set<String> getFacets() {
        return this.doc.getFacets();
    }

    public Serializable getProperty(String key) {
        return this.doc.getPropertyValue(key);
    }

    public Serializable getPropertyValue(String key) {
        return this.doc.getPropertyValue(key);
    }

    public void setProperty(String key, Serializable value) {
        this.doc.setPropertyValue(key, value);
    }

    public void setPropertyValue(String key, Serializable value) {
        this.doc.setPropertyValue(key, value);
    }

    public String getVersionLabel() {
        return this.doc.getVersionLabel();
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            this.doc.getProperty(key.toString());
            return true;
        }
        catch (PropertyException e) {
            return false;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            return this.doc.getProperty(value.toString()).getValue() != null;
        }
        catch (PropertyException e) {
            return false;
        }
    }

    @Override
    public Serializable get(Object key) {
        try {
            return this.doc.getProperty(key.toString()).getValue();
        }
        catch (PropertyException e) {
            return null;
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public Collection<Serializable> values() {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public Set<Map.Entry<String, Serializable>> entrySet() {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public Serializable put(String key, Serializable value) {
        Property p = this.doc.getProperty(key);
        Serializable v = p.getValue();
        p.setValue((Object)value);
        return v;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Serializable> m) {
        throw new UnsupportedOperationException("Read Only Map.");
    }

    @Override
    public Serializable remove(Object key) {
        throw new UnsupportedOperationException("Read Only Map.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Read Only Map.");
    }
}

