/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.trace;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.Constants;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.trace.Trace;

public class Call {
    private static final Logger log = LogManager.getLogger(Call.class);
    public static final String[] MVEL_BLACK_LIST_EXPR = new String[]{"getNextId"};
    protected final String chainId;
    protected final String aliases;
    protected final OperationType type;
    protected final List<Trace> nested = new LinkedList<Trace>();
    protected final Details details;

    protected Call(OperationType chain, OperationType op, Details details) {
        this.type = op;
        this.chainId = chain.getId();
        this.aliases = Arrays.toString(chain.getAliases());
        this.details = details;
    }

    public Call(OperationType chain, OperationType op) {
        this(chain, op, new Details());
    }

    public Call(OperationType chain, OperationContext context, OperationType type, InvokableMethod method, Map<String, Object> parms) {
        this(chain, type, new Details(context, method, parms));
    }

    public OperationType getType() {
        return this.type;
    }

    public InvokableMethod getMethod() {
        return this.details.method;
    }

    public Map<String, Object> getParameters() {
        return this.details.parameters;
    }

    public Map<String, Object> getVariables() {
        return this.details.variables;
    }

    public Object getInput() {
        return this.details.input;
    }

    public Object getOutput() {
        return this.details.output;
    }

    public List<Trace> getNested() {
        return this.nested;
    }

    public String getChainId() {
        return this.chainId;
    }

    public String getAliases() {
        return this.aliases;
    }

    public void print(BufferedWriter writer) throws IOException {
        try {
            writer.append(Constants.LF);
            writer.append(Constants.LF);
            writer.append("****** ");
            writer.append(this.getType().getId());
            writer.append(" ******");
            writer.append(Constants.LF);
            writer.append("Chain ID: ");
            writer.append(this.getChainId());
            if (this.getAliases() != null) {
                writer.append(Constants.LF);
                writer.append("Chain Aliases: ");
                writer.append(this.getAliases());
            }
            writer.append(Constants.LF);
            writer.append("Class: ");
            writer.append(this.getType().getType().getSimpleName());
            writer.append(Constants.LF);
            writer.append("Method: '");
            writer.append(this.getMethod().getMethod().getName());
            writer.append("' | Input Type: ");
            writer.append(this.getMethod().getConsume().getName());
            writer.append(" | Output Type: ");
            writer.append(this.getMethod().getProduce().getName());
            writer.append(Constants.LF);
            writer.append("Input: ");
            writer.append(this.getInput() == null ? "null" : this.getInput().toString());
            if (!this.getParameters().isEmpty()) {
                writer.append(Constants.LF);
                writer.append("Parameters ");
                for (String parameter : this.getParameters().keySet()) {
                    writer.append(" | ");
                    writer.append("Name: ");
                    writer.append(parameter);
                    writer.append(", Value: ");
                    Object value = this.getParameters().get(parameter);
                    if (value instanceof ExpressionParameter) {
                        value = String.format("Expr:(id=%s | value=%s)", ((ExpressionParameter)this.getParameters().get(parameter)).getParameterId(), ((ExpressionParameter)this.getParameters().get(parameter)).getParameterValue());
                    }
                    writer.append(value.toString());
                }
            }
            if (!this.getVariables().isEmpty()) {
                writer.append(Constants.LF);
                writer.append("Context Variables");
                for (String keyVariable : this.getVariables().keySet()) {
                    writer.append(" | ");
                    writer.append("Key: ");
                    writer.append(keyVariable);
                    writer.append(", Value: ");
                    Object variable = this.getVariables().get(keyVariable);
                    if (variable instanceof Calendar) {
                        writer.append(((Calendar)variable).getTime().toString());
                        continue;
                    }
                    writer.append(variable == null ? "null" : variable.toString());
                }
            }
            if (!this.getNested().isEmpty()) {
                this.printHeading("start sub chain", writer);
                for (Trace trace : this.getNested()) {
                    writer.append(Constants.LF);
                    trace.print(writer);
                    writer.append(Constants.LF);
                }
                this.printHeading("end sub chain", writer);
            }
        }
        catch (IOException e) {
            log.error("Nuxeo TracePrinter cannot write traces output", (Throwable)e);
        }
    }

    protected void printHeading(String heading, BufferedWriter writer) throws IOException {
        writer.append(Constants.LF).append(Constants.LF).append("****** ").append(heading).append(" ******");
    }

    protected static class Details {
        protected final Map<String, Object> parameters = new HashMap<String, Object>();
        protected final Map<String, Object> variables = new HashMap<String, Object>();
        protected final InvokableMethod method;
        protected final Object input;
        protected Object output;

        protected Details() {
            this.method = null;
            this.input = null;
        }

        protected Details(OperationContext context, InvokableMethod method, Map<String, Object> parms) {
            this.method = method;
            this.input = context.getInput();
            this.variables.putAll(context);
            parms.forEach(new Evaluator(context)::inject);
        }

        protected class Evaluator {
            protected final OperationContext context;

            protected Evaluator(OperationContext context) {
                this.context = context;
            }

            protected void inject(String key, Object value) {
                if (!(value instanceof Expression)) {
                    Details.this.parameters.put(key, value);
                    return;
                }
                Expression exp = (Expression)value;
                for (String mvelExpr : MVEL_BLACK_LIST_EXPR) {
                    if (!exp.getExpr().contains(mvelExpr)) continue;
                    Details.this.parameters.put(key, new ExpressionParameter(key, String.format("Cannot be evaluated in traces when using '%s' expression", mvelExpr)));
                    return;
                }
                try {
                    Details.this.parameters.put(key, new ExpressionParameter(key, exp.eval(this.context)));
                }
                catch (RuntimeException e) {
                    log.warn("Cannot evaluate mvel expression for parameter: {}", (Object)key, (Object)e);
                }
            }
        }
    }

    public static class ExpressionParameter {
        protected final String parameterId;
        protected final Object parameterValue;

        public ExpressionParameter(String parameterId, Object parameterValue) {
            this.parameterId = parameterId;
            this.parameterValue = parameterValue;
        }

        public Object getParameterValue() {
            return this.parameterValue;
        }

        public String getParameterId() {
            return this.parameterId;
        }
    }
}

