/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.servlet.ServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.web.common.RequestContext;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class JSONObjectBlobDecoder
implements JSONBlobDecoder {
    private static final Logger log = LogManager.getLogger(JSONObjectBlobDecoder.class);
    public static final String DATA_FIELD_NAME = "data";
    public static final String BLOB_URL_FIELD_NAME = "blobUrl";

    @Override
    public Blob getBlobFromJSON(ObjectNode jsonObject) {
        if (!jsonObject.has(DATA_FIELD_NAME)) {
            return null;
        }
        Blob blob = this.getBlobFromField(jsonObject, DATA_FIELD_NAME);
        if (blob == null) {
            blob = this.getBlobFromField(jsonObject, BLOB_URL_FIELD_NAME);
        }
        return blob;
    }

    protected Blob getBlobFromField(ObjectNode jsonObject, String fieldName) {
        JsonNode jsonNode = jsonObject.get(fieldName);
        if (jsonNode == null) {
            return null;
        }
        String blobUrl = jsonNode.textValue();
        return blobUrl != null ? this.getBlobFromURL(blobUrl) : null;
    }

    protected Blob getBlobFromURL(String url) {
        if (!url.startsWith("http")) {
            return null;
        }
        RequestContext activeContext = RequestContext.getActiveContext();
        if (activeContext == null) {
            return null;
        }
        String baseURL = VirtualHostHelper.getBaseURL((ServletRequest)activeContext.getRequest());
        String path = url.replace(baseURL, "");
        if (path.startsWith("http")) {
            return null;
        }
        Blob blob = ((DownloadService)Framework.getService(DownloadService.class)).resolveBlobFromDownloadUrl(path);
        if (blob == null) {
            log.debug("No Blob found for: {}", (Object)url);
            throw new NuxeoException(400);
        }
        return blob;
    }
}

