/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine;

import freemarker.ext.jakarta.jsp.TaglibFactory;
import freemarker.ext.jakarta.servlet.HttpRequestHashModel;
import freemarker.ext.jakarta.servlet.HttpRequestParametersHashModel;
import freemarker.ext.jakarta.servlet.ServletContextHashModel;
import freemarker.template.ObjectWrapper;
import jakarta.servlet.GenericServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Application;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.platform.rendering.api.RenderingEngine;
import org.nuxeo.ecm.platform.rendering.api.ResourceLocator;
import org.nuxeo.ecm.platform.rendering.fm.FreemarkerEngine;
import org.nuxeo.ecm.platform.web.common.RequestContext;
import org.nuxeo.ecm.webengine.app.WebEngineModule;
import org.nuxeo.ecm.webengine.loader.WebLoader;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.impl.ModuleConfiguration;
import org.nuxeo.ecm.webengine.model.impl.ModuleManager;
import org.nuxeo.ecm.webengine.rest.ApplicationFragment;
import org.nuxeo.ecm.webengine.rest.ApplicationHost;
import org.nuxeo.ecm.webengine.rest.ApplicationManager;
import org.nuxeo.ecm.webengine.scripting.ScriptFile;
import org.nuxeo.ecm.webengine.scripting.Scripting;
import org.nuxeo.runtime.annotations.AnnotationManager;
import org.nuxeo.runtime.api.Framework;

public class WebEngine
implements ResourceLocator {
    private static final Logger log = LogManager.getLogger(WebEngine.class);
    public static final String SKIN_PATH_PREFIX_KEY = "org.nuxeo.ecm.webengine.skinPathPrefix";
    protected static final Map<Object, Object> mimeTypes = WebEngine.loadMimeTypes();
    protected final File root;
    protected HashMap<String, WebEngineModule> apps;
    protected volatile ModuleManager moduleMgr;
    protected final Scripting scripting;
    protected final RenderingEngine rendering;
    protected final Map<String, Object> env;
    protected final AnnotationManager annoMgr;
    protected String skinPathPrefix;
    protected final WebLoader webLoader;
    protected volatile boolean isDirty;

    static Map<Object, Object> loadMimeTypes() {
        HashMap<Object, Object> hashMap;
        block8: {
            Properties p = new Properties();
            URL url = WebEngine.class.getClassLoader().getResource("OSGI-INF/mime.properties");
            InputStream in = url.openStream();
            try {
                p.load(in);
                hashMap = new HashMap<Object, Object>(p);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load mime types", e);
                }
            }
            in.close();
        }
        return hashMap;
    }

    public static WebContext getActiveContext() {
        RequestContext ctx = RequestContext.getActiveContext();
        if (ctx != null) {
            WebContext webContext = (WebContext)ctx.getRequest().getAttribute(WebContext.class.getName());
            if (webContext == null) {
                log.warn("No active WebContext found. You might need to set up WebContextProvider as a singleton of your application");
            }
            return webContext;
        }
        return null;
    }

    public WebEngine(File root) {
        this.root = root;
        this.webLoader = new WebLoader(this);
        this.apps = new HashMap();
        this.scripting = new Scripting(this.webLoader);
        this.annoMgr = new AnnotationManager();
        this.skinPathPrefix = Framework.getProperty((String)SKIN_PATH_PREFIX_KEY);
        if (this.skinPathPrefix == null) {
            this.skinPathPrefix = System.getProperty("jboss.home.dir") != null ? "/nuxeo/site/skin" : "/skin";
        }
        this.env = new HashMap<String, Object>();
        this.env.put("installDir", root);
        this.env.put("engine", "Nuxeo Web Engine");
        this.env.put("version", "1.0.0.rc");
        this.rendering = new FreemarkerEngine();
        this.rendering.setResourceLocator((ResourceLocator)this);
        this.rendering.setSharedVariable("env", this.getEnvironment());
    }

    public void loadJspTaglib(GenericServlet servlet) {
        RenderingEngine renderingEngine = this.rendering;
        if (renderingEngine instanceof FreemarkerEngine) {
            FreemarkerEngine fm = (FreemarkerEngine)renderingEngine;
            ServletContextHashModel servletContextModel = new ServletContextHashModel(servlet, (ObjectWrapper)fm.getObjectWrapper());
            fm.setSharedVariable("Application", (Object)servletContextModel);
            fm.setSharedVariable("__FreeMarkerServlet.Application__", (Object)servletContextModel);
            fm.setSharedVariable("Application", (Object)servletContextModel);
            fm.setSharedVariable("__FreeMarkerServlet.Application__", (Object)servletContextModel);
            fm.setSharedVariable("JspTaglibs", (Object)new TaglibFactory(servlet.getServletContext()));
        }
    }

    public void initJspRequestSupport(GenericServlet servlet, HttpServletRequest request, HttpServletResponse response) {
        RenderingEngine renderingEngine = this.rendering;
        if (renderingEngine instanceof FreemarkerEngine) {
            FreemarkerEngine fm = (FreemarkerEngine)renderingEngine;
            HttpRequestHashModel requestModel = new HttpRequestHashModel(request, response, (ObjectWrapper)fm.getObjectWrapper());
            fm.setSharedVariable("__FreeMarkerServlet.Request__", (Object)requestModel);
            fm.setSharedVariable("Request", (Object)requestModel);
            fm.setSharedVariable("RequestParameters", (Object)new HttpRequestParametersHashModel(request));
        }
    }

    public WebLoader getWebLoader() {
        return this.webLoader;
    }

    public void setSkinPathPrefix(String skinPathPrefix) {
        this.skinPathPrefix = skinPathPrefix;
    }

    public String getSkinPathPrefix() {
        return this.skinPathPrefix;
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.webLoader.loadClass(className);
    }

    public String getMimeType(String ext) {
        return (String)mimeTypes.get(ext);
    }

    public AnnotationManager getAnnotationManager() {
        return this.annoMgr;
    }

    public void registerRenderingExtension(String id, Object obj) {
        this.rendering.setSharedVariable(id, obj);
    }

    public void unregisterRenderingExtension(String id) {
        this.rendering.setSharedVariable(id, null);
    }

    public Map<String, Object> getEnvironment() {
        return this.env;
    }

    public Scripting getScripting() {
        return this.scripting;
    }

    public synchronized WebEngineModule[] getApplications() {
        return (WebEngineModule[])this.apps.values().toArray(WebEngineModule[]::new);
    }

    public synchronized void addApplication(WebEngineModule app) {
        this.flushCache();
        this.apps.put(app.getId(), app);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleManager getModuleManager() {
        if (this.moduleMgr == null) {
            WebEngine webEngine = this;
            synchronized (webEngine) {
                if (this.moduleMgr == null) {
                    ModuleManager moduleMgr = new ModuleManager(this);
                    File deployRoot = this.getDeploymentDirectory();
                    if (deployRoot.isDirectory()) {
                        for (String string : deployRoot.list()) {
                            String path = string + "/module.xml";
                            File file = new File(deployRoot, path);
                            if (!file.isFile()) continue;
                            this.webLoader.addClassPathElement(file.getParentFile());
                            moduleMgr.loadModule(file);
                        }
                    }
                    for (WebEngineModule webEngineModule : this.getApplications()) {
                        ModuleConfiguration mc = webEngineModule.getConfiguration();
                        moduleMgr.loadModule(mc);
                    }
                    this.moduleMgr = moduleMgr;
                }
            }
        }
        return this.moduleMgr;
    }

    public Module getModule(String name) {
        ModuleConfiguration md = this.getModuleManager().getModule(name);
        if (md != null) {
            return md.get();
        }
        return null;
    }

    public File getRootDirectory() {
        return this.root;
    }

    public File getDeploymentDirectory() {
        return new File(this.root, "deploy");
    }

    public File getModulesDirectory() {
        return new File(this.root, "modules");
    }

    public RenderingEngine getRendering() {
        return this.rendering;
    }

    public synchronized void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryReload() {
        if (this.isDirty) {
            WebEngine webEngine = this;
            synchronized (webEngine) {
                if (this.isDirty) {
                    this.reload();
                    return true;
                }
            }
        }
        return false;
    }

    public synchronized boolean isDirty() {
        return this.isDirty;
    }

    public synchronized void flushCache() {
        this.isDirty = false;
        if (this.moduleMgr != null) {
            this.webLoader.flushCache();
            this.moduleMgr = null;
        }
    }

    public synchronized void reload() {
        log.info("Reloading WebEngine");
        this.isDirty = false;
        this.webLoader.flushCache();
        this.apps = new HashMap();
        if (this.moduleMgr != null) {
            for (ModuleConfiguration mc : this.moduleMgr.getModules()) {
                mc.flushCache();
            }
            this.moduleMgr = null;
        }
    }

    public synchronized void reloadModules() {
        if (this.moduleMgr != null) {
            this.moduleMgr.reloadModules();
        }
    }

    public void start() {
        ApplicationHost[] hosts;
        for (ApplicationHost host : hosts = ApplicationManager.getInstance().getApplications()) {
            for (ApplicationFragment fragment : host.getApplications()) {
                Application app = fragment.getApplication();
                if (!(app instanceof WebEngineModule)) continue;
                this.addApplication((WebEngineModule)app);
            }
        }
    }

    public void stop() {
        this.moduleMgr = null;
    }

    protected ModuleConfiguration getModuleFromPath(String rootPath, String path) {
        path = path.substring(rootPath.length() + 1);
        int p = path.indexOf(47);
        String moduleName = path;
        if (p > -1) {
            moduleName = path.substring(0, p);
        }
        return this.moduleMgr.getModule(moduleName);
    }

    public URL getResourceURL(String key) {
        try {
            return new URL(key);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public File getResourceFile(String key) {
        WebContext ctx = WebEngine.getActiveContext();
        if (key.startsWith("@")) {
            Resource rs = ctx.getTargetObject();
            if (rs != null) {
                return rs.getView(key.substring(1)).script().getFile();
            }
        } else {
            ScriptFile file = ctx.getFile(key);
            if (file != null) {
                return file.getFile();
            }
        }
        return null;
    }
}

