/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.app.WebContextProvider;
import org.nuxeo.ecm.webengine.app.WebEngineModuleFactory;
import org.nuxeo.ecm.webengine.loader.WebLoader;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleConfiguration;
import org.nuxeo.ecm.webengine.model.impl.ModuleManager;
import org.nuxeo.ecm.webengine.rest.ApplicationFactory;
import org.nuxeo.ecm.webengine.rest.scan.Scanner;
import org.osgi.framework.Bundle;

public class WebEngineModule
extends Application
implements ApplicationFactory {
    private static final Logger log = LogManager.getLogger(WebEngineModule.class);
    protected Bundle bundle;
    protected ModuleConfiguration cfg;

    void init(WebEngine engine, Bundle bundle, File configuration, Map<String, String> attrs) throws ReflectiveOperationException, IOException {
        this.bundle = bundle;
        this.loadModuleConfigurationFile(engine, configuration);
        if (attrs != null) {
            String v = attrs.get("name");
            if (v != null) {
                this.cfg.name = v;
            }
            if ((v = attrs.get("extends")) != null) {
                this.cfg.base = v;
            }
            if ((v = attrs.get("headless")) != null) {
                this.cfg.isHeadless = Boolean.parseBoolean(v);
            }
        }
        if (this.cfg.name == null) {
            throw new IllegalStateException("No name given for web module in bundle " + bundle.getSymbolicName());
        }
        this.initTypes(bundle, attrs.get("package"), engine);
    }

    private void initTypes(Bundle bundle, String packageBase, WebEngine engine) throws ReflectiveOperationException, IOException {
        this.cfg.types = this.getWebTypes();
        if (this.cfg.types == null) {
            this.loadMetaTypeFile(engine);
            if (this.cfg.types == null) {
                this.scan(bundle, packageBase);
                if (this.cfg.types == null) {
                    throw new IllegalStateException("No web types defined in web module " + this.cfg.name + " from bundle " + bundle.getSymbolicName());
                }
            } else {
                this.initRoots();
            }
        } else {
            this.initRoots();
        }
    }

    private void scan(Bundle bundle, String packageBase) throws ReflectiveOperationException, IOException {
        if (packageBase == null) {
            packageBase = "/";
        }
        Scanner scanner = new Scanner(bundle, packageBase, new Class[]{Path.class, Provider.class, WebObject.class, WebAdapter.class});
        scanner.scan();
        Set paths = scanner.getClasses(Path.class);
        Set providers = scanner.getClasses(Provider.class);
        this.cfg.roots = new Class[paths.size() + providers.size()];
        int i = 0;
        for (Class cl : paths) {
            this.cfg.roots[i++] = cl;
        }
        for (Class cl : providers) {
            this.cfg.roots[i++] = cl;
        }
        Set objs = scanner.getClasses(WebObject.class);
        Set adapters = scanner.getClasses(WebAdapter.class);
        this.cfg.types = new Class[objs.size() + adapters.size()];
        i = 0;
        for (Class cl : objs) {
            this.cfg.types[i++] = cl;
        }
        for (Class cl : adapters) {
            this.cfg.types[i++] = cl;
        }
    }

    private void loadMetaTypeFile(WebEngine engine) throws ReflectiveOperationException, IOException {
        URL url = this.bundle.getEntry("META-INF/web-types");
        if (url != null) {
            try (InputStream in = url.openStream();){
                this.cfg.types = WebEngineModule.readWebTypes(engine.getWebLoader(), in);
            }
        }
    }

    private static Class<?>[] readWebTypes(WebLoader loader, InputStream in) throws ReflectiveOperationException, IOException {
        HashSet types = new HashSet();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                int p = line.indexOf(124);
                if (p > -1) {
                    line = line.substring(0, p);
                }
                Class<?> cl = loader.loadClass(line);
                types.add(cl);
            }
        }
        return (Class[])types.toArray(Class[]::new);
    }

    private void initRoots() {
        ArrayList roots = new ArrayList();
        for (Class<?> cl : this.cfg.types) {
            if (!cl.isAnnotationPresent(Path.class)) continue;
            roots.add(cl);
        }
        if (roots.isEmpty()) {
            log.error("No root web objects found in web module: {} from bundle: {}", (Object)this.cfg.name, (Object)this.bundle.getSymbolicName());
        }
        this.cfg.roots = (Class[])roots.toArray(Class[]::new);
    }

    private ModuleConfiguration loadModuleConfigurationFile(WebEngine engine, File file) throws IOException {
        this.cfg = file != null && file.isFile() ? ModuleManager.readConfiguration(engine, file) : new ModuleConfiguration(engine);
        return this.cfg;
    }

    public ModuleConfiguration getConfiguration() {
        return this.cfg;
    }

    public Module getModule(WebContext context) {
        return this.cfg.get();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Set<Class<?>> getClasses() {
        if (this.cfg.roots == null) {
            return new HashSet();
        }
        HashSet set = new HashSet();
        Collections.addAll(set, this.cfg.roots);
        set.add(WebContextProvider.class);
        return set;
    }

    public String getId() {
        return this.bundle.getSymbolicName();
    }

    public Class<?>[] getWebTypes() {
        return null;
    }

    public Application getApplication(Bundle bundle, Map<String, String> args) throws ReflectiveOperationException, IOException {
        return WebEngineModuleFactory.getApplication(this, bundle, args);
    }

    public String toString() {
        return "WebEngineModule{cfg=" + String.valueOf(this.cfg) + ", bundle=" + String.valueOf(this.bundle) + "}";
    }
}

