/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.loader;

import groovy.lang.GroovyClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.codehaus.groovy.classgen.Verifier;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.loader.ClassProxy;

public class GroovyClassProxy
implements ClassProxy {
    private static final Logger log = LogManager.getLogger(GroovyClassProxy.class);
    protected final GroovyClassLoader loader;
    protected final String className;
    protected long timestamp = 0L;

    public GroovyClassProxy(GroovyClassLoader loader, String className) {
        this.loader = loader;
        this.className = className;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Class<?> get() {
        try {
            Class clazz = this.loader.loadClass(this.className, true, false);
            long tm = Verifier.getTimestamp((Class)clazz);
            if (this.timestamp > 0L && this.timestamp < tm) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = clazz::getName;
                log.debug("CLASS CHANGED: {}", supplierArray);
            }
            this.timestamp = tm;
            return clazz;
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public String toString() {
        return this.className;
    }
}

