/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.model.LinkHandler;
import org.nuxeo.ecm.webengine.model.LinkHandlerFactory;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.security.Guard;
import org.nuxeo.ecm.webengine.security.PermissionService;

@XObject(value="link")
public class LinkDescriptor
implements Cloneable,
LinkHandler {
    @XNode(value="@id")
    protected String id;
    @XNode(value="@path")
    protected String path;
    @XNode(value="@fragment")
    protected String fragment;
    protected volatile LinkHandler handler;
    @XNode(value="@handler")
    protected String handlerClass;
    @XNodeList(value="category", type=ArrayList.class, componentType=String.class, nullByDefault=false)
    protected List<String> categories;
    @XNode(value="type")
    protected String type = "*";
    @XNode(value="adapter")
    protected String adapter = "*";
    @XNodeList(value="facet", type=String[].class, componentType=String.class, nullByDefault=true)
    protected String[] facets;
    protected Guard guard = Guard.DEFAULT;

    public LinkDescriptor() {
    }

    public LinkDescriptor(String id) {
        this(id, null);
    }

    public LinkDescriptor(String id, String fragment) {
        this.id = id;
        this.fragment = fragment;
    }

    @XNode(value="guard")
    public void setGuard(String expr) throws ParseException {
        this.guard = PermissionService.parse(expr);
    }

    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public void setHandler(LinkHandler handler) {
        this.handler = handler;
    }

    public String getCode(Resource resource) {
        try {
            if (this.handler == null) {
                Object obj;
                this.handler = this.handlerClass != null ? ((obj = resource.getModule().loadClass(this.handlerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) instanceof LinkHandlerFactory ? ((LinkHandlerFactory)obj).getHandler(this, resource) : (LinkHandler)obj) : this;
            }
            return this.handler.getCode(this, resource);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("Failed to instantiate link handler", (Throwable)e);
        }
    }

    public LinkHandler getHandler() {
        return this.handler;
    }

    public String getAdapter() {
        return this.adapter;
    }

    public String getType() {
        return this.type;
    }

    public String[] getFacets() {
        return this.facets;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public void addCategories(Collection<String> categories) {
        this.categories.addAll(categories);
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public boolean hasCategory(String category) {
        return this.categories != null && this.categories.contains(category);
    }

    public boolean acceptResource(Resource context) {
        if (this.type == "*" && this.adapter == "*" && this.facets == null) {
            return true;
        }
        if (this.facets != null) {
            for (String facet : this.facets) {
                if (context.hasFacet(facet)) continue;
                return false;
            }
        }
        if (this.type != "*") {
            if (this.adapter != "*") {
                if (!context.isInstanceOf(this.type)) {
                    return false;
                }
            } else {
                return context.isInstanceOf(this.type);
            }
        }
        if (this.adapter != "*") {
            Resource adapterRs = context.getNext();
            if (adapterRs != null && adapterRs.isAdapter()) {
                return adapterRs.isInstanceOf(this.adapter);
            }
            return false;
        }
        return true;
    }

    public boolean isEnabled(Resource context) {
        if (this.acceptResource(context)) {
            return this.guard == null || this.guard.check(context);
        }
        return false;
    }

    @Override
    public String getCode(LinkDescriptor link, Resource resource) {
        String parentPath = this.adapter != "*" ? resource.getActiveAdapter().getPath() : resource.getPath();
        StringBuilder res = new StringBuilder();
        res.append(parentPath);
        if (parentPath != null && parentPath.endsWith("/") && this.path != null && this.path.startsWith("/")) {
            res.append(this.path.substring(1));
        } else {
            res.append(this.path);
        }
        return res.toString();
    }

    public boolean isFragment() {
        return this.fragment != null;
    }

    public void applyFragment(LinkDescriptor fragment) {
        if (fragment.categories != null && !fragment.categories.isEmpty()) {
            if (this.categories == null) {
                this.categories = new ArrayList<String>(fragment.categories);
            } else {
                this.categories.addAll(fragment.categories);
            }
        }
        if (fragment.type != null && !fragment.type.equals("*")) {
            this.type = fragment.type;
        }
        if (fragment.adapter != null && !fragment.adapter.equals("*")) {
            this.adapter = fragment.adapter;
        }
        if (fragment.facets != null && fragment.facets.length > 0) {
            if (this.facets == null) {
                this.facets = fragment.facets;
            } else {
                HashSet<String> set = new HashSet<String>();
                set.addAll(Arrays.asList(this.facets));
                set.addAll(Arrays.asList(fragment.facets));
                this.facets = (String[])set.toArray(String[]::new);
            }
        }
        if (fragment.handlerClass != null) {
            this.handler = null;
            this.handlerClass = fragment.handlerClass;
        }
        if (fragment.guard != null) {
            this.guard = fragment.guard;
        }
        if (fragment.path != null) {
            this.path = fragment.path;
        }
        this.fragment = fragment.fragment;
    }

    public LinkDescriptor clone() throws CloneNotSupportedException {
        return (LinkDescriptor)super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof LinkDescriptor) {
            LinkDescriptor ld = (LinkDescriptor)obj;
            return this.id.equals(ld.id) && Objects.equals(this.fragment, ld.fragment);
        }
        return false;
    }

    public String toString() {
        return this.id;
    }
}

