/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.loader.ClassProxy;
import org.nuxeo.ecm.webengine.model.Guard;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.ResourceType;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.scripting.ScriptFile;
import org.nuxeo.ecm.webengine.scripting.ScriptJarFile;
import org.nuxeo.ecm.webengine.security.PermissionService;
import org.nuxeo.runtime.annotations.AnnotationManager;

public abstract class AbstractResourceType
implements ResourceType {
    protected final WebEngine engine;
    protected final Module owner;
    protected final String name;
    protected int visibility = 2;
    protected AbstractResourceType superType;
    protected volatile ClassProxy clazz;
    protected volatile org.nuxeo.ecm.webengine.security.Guard guard = org.nuxeo.ecm.webengine.security.Guard.DEFAULT;
    protected volatile Set<String> facets;
    protected volatile ConcurrentMap<String, ScriptFile> templateCache;

    protected AbstractResourceType(WebEngine engine, Module module, AbstractResourceType superType, String name, ClassProxy clazz, int visibility) {
        this.engine = engine;
        this.owner = module;
        this.superType = superType;
        this.name = name;
        this.clazz = clazz;
        this.visibility = visibility;
        this.templateCache = new ConcurrentHashMap<String, ScriptFile>();
        AnnotationManager mgr = engine.getAnnotationManager();
        this.loadAnnotations(mgr);
    }

    public int getVisibility() {
        return this.visibility;
    }

    protected abstract void loadAnnotations(AnnotationManager var1);

    @Override
    public ResourceType getSuperType() {
        return this.superType;
    }

    public Module getOwnerModule() {
        return this.owner;
    }

    @Override
    public org.nuxeo.ecm.webengine.security.Guard getGuard() {
        return this.guard;
    }

    @Override
    public Set<String> getFacets() {
        return this.facets;
    }

    @Override
    public boolean hasFacet(String facet) {
        return this.facets != null && this.facets.contains(facet);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <R extends Resource> Class<R> getResourceClass() {
        return this.clazz.get();
    }

    @Override
    public <R extends Resource> R newInstance() {
        try {
            return (R)((Resource)this.getResourceClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("Failed to instantiate web object: " + String.valueOf(this.clazz), (Throwable)e);
        }
    }

    @Override
    public boolean isEnabled(Resource ctx) {
        return this.guard.check(ctx);
    }

    @Override
    public boolean isDerivedFrom(String type) {
        if (type.equals(this.name)) {
            return true;
        }
        if (this.superType != null) {
            return this.superType.isDerivedFrom(type);
        }
        return false;
    }

    @Override
    public void flushCache() {
        this.templateCache = new ConcurrentHashMap<String, ScriptFile>();
    }

    protected void loadGuardFromAnnotation(Class<?> c) {
        Guard ag = c.getAnnotation(Guard.class);
        if (ag != null) {
            String g = ag.value();
            if (g != null && !g.isEmpty()) {
                try {
                    this.guard = PermissionService.parse(g);
                }
                catch (ParseException e) {
                    throw new NuxeoException("Failed to parse guard: " + g + " on WebObject " + c.getName(), (Throwable)e);
                }
            }
            Class<?> gc = ag.type();
            if (gc != null) {
                try {
                    this.guard = (org.nuxeo.ecm.webengine.security.Guard)gc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new NuxeoException("Failed to instantiate guard handler: " + gc.getName() + " on WebObject " + c.getName(), (Throwable)e);
                }
            }
        }
    }

    public String toString() {
        return this.name + " extends " + String.valueOf(this.superType) + " [" + this.getResourceClass().getName() + "]";
    }

    @Override
    public ScriptFile getView(Module module, String name) {
        ScriptFile file = this.findView(module, name);
        if (file == null) {
            throw new WebResourceNotFoundException("Template " + name + " not found for object of type " + this.getName());
        }
        return file;
    }

    public ScriptFile findView(Module module, String name) {
        AbstractResourceType t;
        ScriptFile file = (ScriptFile)this.templateCache.get(name);
        if (file != null) {
            return file;
        }
        file = this.findSkinTemplate(module, name);
        if (file == null) {
            file = this.findTypeTemplate(module, name);
        }
        if (file == null && (t = (AbstractResourceType)this.getSuperType()) != null) {
            file = t.findView(module, name);
        }
        if (file != null) {
            this.templateCache.put(name, file);
        }
        return file;
    }

    protected ScriptFile findSkinTemplate(Module module, String name) {
        return module.getFile("views" + File.separatorChar + this.name + File.separatorChar + name);
    }

    protected ScriptFile findTypeTemplate(Module module, String name) {
        String path = this.resolveResourcePath(this.clazz.getClassName(), name);
        URL url = this.clazz.get().getResource(path);
        if (url != null) {
            try {
                if ("file".equals(url.getProtocol())) {
                    return new ScriptFile(new File(url.toURI()));
                }
                if ("jar".equals(url.getProtocol())) {
                    return new ScriptJarFile(url);
                }
                return null;
            }
            catch (IOException | URISyntaxException e) {
                throw new NuxeoException("Failed to convert URL to URI: " + String.valueOf(url), (Throwable)e);
            }
        }
        return null;
    }

    protected String resolveResourcePath(String className, String fileName) {
        String path = className;
        int p = path.lastIndexOf(46);
        if (p > -1) {
            path = path.substring(0, p);
            path = path.replace('.', '/');
            return "/" + path + "/" + fileName;
        }
        return "/" + fileName;
    }
}

