/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Date;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.ModuleResource;
import org.nuxeo.ecm.webengine.model.ResourceType;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleConfiguration;
import org.nuxeo.ecm.webengine.scripting.ScriptFile;
import org.nuxeo.runtime.api.Framework;

public class ModuleRoot
extends DefaultObject
implements ModuleResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Context
    public void setContext(WebContext context) {
        if (context.getModule() != null) {
            return;
        }
        try {
            Module module = this.findModule();
            ResourceType type = module.getType(this.getClass().getAnnotation(WebObject.class).type());
            context.setModule(module);
            this.initialize(context, type, new Object[0]);
            this.setRoot(true);
        }
        finally {
            context.push(this);
            CoreInstance.setThrowable(null);
        }
    }

    private Module findModule() {
        Path path = this.getClass().getAnnotation(Path.class);
        if (path == null) {
            throw new IllegalStateException("ModuleRoot not annotated with @Path: " + String.valueOf(this.getClass()));
        }
        ModuleConfiguration mc = ((WebEngine)Framework.getService(WebEngine.class)).getModuleManager().getModuleByRootClass(this.getClass());
        if (mc == null) {
            throw new IllegalStateException("No module found for root resource: " + String.valueOf(this.getClass()));
        }
        return mc.get();
    }

    @GET
    @Path(value="skin/{path:.*}")
    public Response getSkinResource(@PathParam(value="path") String path) {
        try {
            ScriptFile file = this.getModule().getSkinResource("/resources/" + path);
            if (file != null) {
                long lastModified = file.lastModified();
                Response.ResponseBuilder resp = Response.ok((Object)file.getFile()).lastModified(new Date(lastModified)).header("Cache-Control", (Object)"public").header("Server", (Object)"Nuxeo/WebEngine-1.0");
                String mimeType = this.ctx.getEngine().getMimeType(file.getExtension());
                if (mimeType == null) {
                    mimeType = "text/plain";
                }
                resp.type(mimeType);
                return resp.build();
            }
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to get resource file: " + path, (Throwable)e);
        }
        return Response.status((int)404).build();
    }

    @Override
    public String getLink(DocumentModel doc) {
        return this.getPath() + "/@nxdoc/" + doc.getId();
    }

    @Override
    public Object handleError(Throwable t) {
        CoreInstance.setThrowable((Throwable)t);
        return t;
    }
}

