/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.loader.ClassProxy;
import org.nuxeo.ecm.webengine.model.Access;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResourceType;
import org.nuxeo.ecm.webengine.model.impl.ModuleImpl;
import org.nuxeo.ecm.webengine.security.PermissionService;
import org.nuxeo.ecm.webengine.security.guards.And;
import org.nuxeo.ecm.webengine.security.guards.IsAdministratorGuard;
import org.nuxeo.runtime.annotations.AnnotationManager;

public class ResourceTypeImpl
extends AbstractResourceType {
    public ResourceTypeImpl(WebEngine engine, ModuleImpl module, ResourceTypeImpl superType, String name, ClassProxy clazz, int visibility) {
        super(engine, module, superType, name, clazz, visibility);
    }

    @Override
    protected void loadAnnotations(AnnotationManager annoMgr) {
        String[] facets;
        Class<?> c = this.clazz.get();
        WebObject wo = c.getAnnotation(WebObject.class);
        if (wo == null) {
            return;
        }
        String g = wo.guard();
        if (g != null && !g.isEmpty()) {
            try {
                this.guard = PermissionService.parse(g);
            }
            catch (ParseException e) {
                throw new NuxeoException("Failed to parse guard: " + g + " on WebObject " + c.getName(), (Throwable)e);
            }
        } else {
            this.loadGuardFromAnnotation(c);
        }
        Access requireAdministrators = wo.administrator();
        if (requireAdministrators != Access.NULL) {
            this.guard = this.guard != null ? new And(new IsAdministratorGuard(requireAdministrators), this.guard) : new IsAdministratorGuard(requireAdministrators);
        }
        if ((facets = wo.facets()) != null && facets.length > 0) {
            this.facets = new HashSet<String>(Arrays.asList(facets));
        }
    }
}

