/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.nuxeo.ecm.webengine.model.impl.AdapterDescriptor;
import org.nuxeo.ecm.webengine.model.impl.TypeDescriptor;
import org.nuxeo.ecm.webengine.model.impl.TypeRegistry;

public class TypeConfigurationProvider {
    protected final List<TypeDescriptor> types = new ArrayList<TypeDescriptor>();
    protected final List<AdapterDescriptor> services = new ArrayList<AdapterDescriptor>();
    protected final List<TypeRegistry> registries = new Vector<TypeRegistry>();

    public void flushCache() {
    }

    public synchronized boolean isEmpty() {
        return this.types.isEmpty() && this.services.isEmpty();
    }

    public synchronized void registerType(TypeDescriptor td) {
        this.types.add(td);
        this.fireTypeRegistered(td);
    }

    public synchronized void unregisterType(TypeDescriptor td) {
        if (this.types.remove(td)) {
            this.fireTypeUnregistered(td);
        }
    }

    public synchronized void registerAction(AdapterDescriptor ad) {
        this.services.add(ad);
        this.fireServiceRegistered(ad);
    }

    public synchronized void unregisterAction(AdapterDescriptor ad) {
        if (this.services.remove(ad)) {
            this.fireServiceUnregistered(ad);
        }
    }

    public void addRegistry(TypeRegistry registry) {
        this.registries.add(registry);
    }

    public void removeRegistry(TypeRegistry listener) {
        this.registries.remove(listener);
    }

    public synchronized void install(TypeRegistry registry) {
        for (TypeDescriptor td : this.types) {
            registry.registerType(td);
        }
        for (AdapterDescriptor ad : this.services) {
            registry.registerAdapter(ad);
        }
        this.addRegistry(registry);
    }

    protected void fireServiceRegistered(AdapterDescriptor ad) {
        if (this.registries.isEmpty()) {
            return;
        }
        for (TypeRegistry reg : (TypeRegistry[])this.registries.toArray(TypeRegistry[]::new)) {
            reg.registerAdapter(ad);
        }
    }

    protected void fireServiceUnregistered(AdapterDescriptor ad) {
        if (this.registries.isEmpty()) {
            return;
        }
        for (TypeRegistry reg : (TypeRegistry[])this.registries.toArray(TypeRegistry[]::new)) {
            reg.unregisterAdapter(ad);
        }
    }

    protected void fireTypeRegistered(TypeDescriptor td) {
        if (this.registries.isEmpty()) {
            return;
        }
        for (TypeRegistry listener : (TypeRegistry[])this.registries.toArray(TypeRegistry[]::new)) {
            listener.registerType(td);
        }
    }

    protected void fireTypeUnregistered(TypeDescriptor td) {
        if (this.registries.isEmpty()) {
            return;
        }
        for (TypeRegistry listener : (TypeRegistry[])this.registries.toArray(TypeRegistry[]::new)) {
            listener.unregisterType(td);
        }
    }
}

