/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.io;

import jakarta.inject.Singleton;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.io.download.DownloadHelper;

@Singleton
@Provider
@Produces(value={"*/*", "text/plain"})
public class FileWriter
implements MessageBodyWriter<File> {
    public void writeTo(File t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try (FileInputStream in = new FileInputStream(t);){
            IOUtils.copy((InputStream)in, (OutputStream)entityStream);
            entityStream.flush();
        }
        catch (IOException e) {
            if (DownloadHelper.isClientAbortError((Throwable)e)) {
                DownloadHelper.logClientAbort((Throwable)e);
            }
            throw new NuxeoException("Failed to render resource", (Throwable)e);
        }
    }

    public long getSize(File arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        long n = arg0.length();
        return n <= 0L ? -1L : n;
    }

    public boolean isWriteable(Class<?> arg0, Type type, Annotation[] arg2, MediaType arg3) {
        return File.class.isAssignableFrom(arg0);
    }
}

