/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.rendering;

import freemarker.template.AdapterTemplateModel;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.HashMap;
import java.util.List;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;

public class ScriptMethod
implements TemplateMethodModelEx {
    public Object exec(List arguments) throws TemplateModelException {
        WebContext ctx;
        int size = arguments.size();
        if (size < 1) {
            throw new TemplateModelException("Invalid number of arguments for script(...) method");
        }
        SimpleScalar val = (SimpleScalar)arguments.get(0);
        if (val == null) {
            throw new TemplateModelException("src attribute is required");
        }
        String src = val.getAsString();
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (arguments.size() > 1) {
            Object o = arguments.get(1);
            if (o instanceof SimpleScalar) {
                String arg = ((SimpleScalar)o).getAsString();
                args.put("_args", new String[]{arg});
            } else if (o instanceof TemplateHashModelEx) {
                TemplateHashModelEx t = (TemplateHashModelEx)o;
                TemplateCollectionModel keys = t.keys();
                for (TemplateModel k : keys) {
                    Object vv;
                    String kk = k.toString();
                    TemplateModel v = t.get(kk);
                    if (v instanceof AdapterTemplateModel) {
                        AdapterTemplateModel adapter = (AdapterTemplateModel)v;
                        vv = adapter.getAdaptedObject(null);
                    } else {
                        vv = v.toString();
                    }
                    args.put(kk, vv);
                }
            } else {
                throw new TemplateModelException("second argument should be a map");
            }
        }
        if ((ctx = WebEngine.getActiveContext()) != null) {
            try {
                return ctx.runScript(src, args);
            }
            catch (NuxeoException e) {
                throw new TemplateModelException("Failed to run script: " + src, (Exception)((Object)e));
            }
        }
        throw new IllegalStateException("Not In a Web Context");
    }
}

