/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.scripting;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.runtime.api.Framework;

public class ScriptFile {
    public static final String ROOT_PATH = ((WebEngine)Framework.getService(WebEngine.class)).getRootDirectory().getAbsolutePath();
    protected File file;
    protected final String ext;

    protected ScriptFile(String ext) {
        this.ext = ext;
    }

    public ScriptFile(File file) throws IOException {
        String name = file.getName();
        FileUtils.checkPathTraversal((String)name);
        int p = name.lastIndexOf(46);
        this.ext = p > -1 ? name.substring(p + 1) : "";
        this.file = file.getCanonicalFile();
    }

    public boolean isTemplate() {
        return "ftl".equals(this.ext);
    }

    public File getFile() {
        return this.file;
    }

    public String getExtension() {
        return this.ext;
    }

    public String getAbsolutePath() {
        return this.getFile().getAbsolutePath();
    }

    public String getRelativePath() {
        return this.getAbsolutePath().substring(ROOT_PATH.length());
    }

    public String getFileName() {
        return this.getFile().getName();
    }

    public String getURL() throws MalformedURLException {
        return this.getFile().toURI().toURL().toExternalForm();
    }

    public URL toURL() throws MalformedURLException {
        return this.getFile().toURI().toURL();
    }

    public URI toURI() {
        return this.getFile().toURI();
    }

    public long lastModified() {
        return this.getFile().lastModified();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.getFile());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

