/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.scripting;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.webengine.scripting.ScriptFile;
import org.nuxeo.runtime.api.Framework;

public class ScriptJarFile
extends ScriptFile {
    protected final URL url;

    public ScriptJarFile(URL url) {
        super(FilenameUtils.getExtension((String)url.getPath()));
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getFile() {
        if (this.file == null) {
            ScriptJarFile scriptJarFile = this;
            synchronized (scriptJarFile) {
                if (this.file == null) {
                    try {
                        File tempFile = Framework.createTempFile((String)"template-", (String)("." + this.ext));
                        IOUtils.copy((URL)this.url, (File)tempFile);
                        this.file = tempFile;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.file;
    }

    @Override
    public String getAbsolutePath() {
        return this.url.getFile();
    }

    @Override
    public String getFileName() {
        return FilenameUtils.getName((String)this.url.getFile());
    }

    @Override
    public String getURL() throws MalformedURLException {
        return this.url.toExternalForm();
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return this.url;
    }

    @Override
    public URI toURI() {
        try {
            return this.url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long lastModified() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.url.openStream();
    }
}

