/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.runtime.annotations.AnnotatedClass;

public class AnnotatedMethod {
    protected final AnnotatedClass<?> aclass;
    protected final Method method;
    protected final Map<Class<? extends Annotation>, Annotation> annotations;

    AnnotatedMethod(AnnotatedClass<?> aclass, Method method) {
        this(aclass, method, new HashMap<Class<? extends Annotation>, Annotation>());
    }

    AnnotatedMethod(AnnotatedClass<?> aclass, Method method, Map<Class<? extends Annotation>, Annotation> annos) {
        this.aclass = aclass;
        this.method = method;
        this.annotations = annos;
    }

    public AnnotatedClass<?> getAnnotatedClass() {
        return this.aclass;
    }

    public Method getMethod() {
        return this.method;
    }

    public Annotation[] getAnnotations() {
        return (Annotation[])this.annotations.values().toArray(Annotation[]::new);
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.method.getDeclaredAnnotations();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return (A)this.annotations.get(annotationClass);
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationClass) {
        return this.method.getAnnotation(annotationClass);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.annotations.containsKey(annotationClass);
    }

    public boolean isDeclaringAnnotation(Class<? extends Annotation> annotationClass) {
        return this.method.isAnnotationPresent(annotationClass);
    }
}

