/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.runtime.annotations.AnnotatedMethod;

class MethodAnnotations {
    protected final List<Entry> entries = new ArrayList<Entry>();

    MethodAnnotations() {
    }

    public void addMethods(Class<?> clazz) {
        for (Method m : clazz.getDeclaredMethods()) {
            this.addMethod(m);
        }
    }

    public void addMethod(Method m) {
        int mod = m.getModifiers();
        if (!Modifier.isPublic(mod) && !Modifier.isProtected(mod)) {
            return;
        }
        Annotation[] annos = m.getDeclaredAnnotations();
        if (annos.length == 0) {
            return;
        }
        for (Entry entry : this.entries) {
            if (!entry.isSameAs(m)) continue;
            for (Annotation anno : annos) {
                Class<? extends Annotation> annoType = anno.annotationType();
                Annotation a = entry.annos.get(annoType);
                if (a == null) {
                    entry.annos.put(anno.annotationType(), anno);
                    entry.method = m;
                    continue;
                }
                entry.annos.put(anno.annotationType(), anno);
                entry.method = m;
            }
            return;
        }
        this.entries.add(new Entry(m, annos));
    }

    public void addSuperMethod(AnnotatedMethod am) {
        for (Entry entry : this.entries) {
            Annotation[] annos;
            if (!entry.isSameAs(am.method)) continue;
            for (Annotation anno : annos = am.getAnnotations()) {
                Class<? extends Annotation> annoType = anno.annotationType();
                Annotation a = entry.annos.get(annoType);
                if (a == null) {
                    entry.annos.put(anno.annotationType(), anno);
                    continue;
                }
                entry.annos.put(anno.annotationType(), anno);
            }
            return;
        }
        this.entries.add(new Entry(am.method, am.getAnnotations()));
    }

    static class Entry {
        final Class<?>[] parameterTypes;
        Method method;
        final Map<Class<? extends Annotation>, Annotation> annos;

        Entry(Method method, Annotation[] annos) {
            this.method = method;
            this.parameterTypes = method.getParameterTypes();
            this.annos = new HashMap<Class<? extends Annotation>, Annotation>();
            for (Annotation anno : annos) {
                this.annos.put(anno.annotationType(), anno);
            }
        }

        public boolean isSameAs(Method m) {
            Class<?>[] pt;
            if (this.method.getName().equals(m.getName()) && this.method.getReturnType() == m.getReturnType() && this.parameterTypes.length == (pt = m.getParameterTypes()).length) {
                for (int i = 0; i < this.parameterTypes.length; ++i) {
                    if (this.parameterTypes[i] == pt[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

