/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

public class DocumentTreeIterator
implements Iterator<DocumentModel> {
    protected final CoreSession session;
    protected final DocumentModel root;
    protected Iterator<DocumentModel> sequence;
    protected final Queue<Iterator<DocumentModel>> queue = new LinkedList<Iterator<DocumentModel>>();

    public DocumentTreeIterator(CoreSession session, DocumentModel root) {
        this(session, root, false);
    }

    public DocumentTreeIterator(CoreSession session, DocumentModel root, boolean excludeRoot) {
        this.root = root;
        this.session = session;
        this.sequence = excludeRoot ? session.getChildrenIterator(root.getRef(), null, null, null) : new OneDocSequence(root);
    }

    protected Iterator<DocumentModel> getNextNonEmptySequence() {
        Iterator<DocumentModel> seq;
        do {
            if ((seq = this.queue.poll()) != null) continue;
            return null;
        } while (!seq.hasNext());
        return seq;
    }

    @Override
    public boolean hasNext() {
        if (this.sequence == null || !this.sequence.hasNext()) {
            this.sequence = this.getNextNonEmptySequence();
            if (this.sequence == null) {
                return false;
            }
        }
        return true;
    }

    @Override
    public DocumentModel next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no more documents to iterate over");
        }
        DocumentModel doc = this.sequence.next();
        if (doc.isFolder()) {
            this.queue.add(this.session.getChildrenIterator(doc.getRef(), null, null, null));
        }
        return doc;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not yet supported");
    }

    public void reset() {
        this.sequence = new OneDocSequence(this.root);
        this.queue.clear();
    }

    static class OneDocSequence
    implements Iterator<DocumentModel> {
        final DocumentModel doc;
        boolean hasNext = true;

        OneDocSequence(DocumentModel doc) {
            this.doc = doc;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public DocumentModel next() {
            if (this.doc == null) {
                throw new NoSuchElementException("no more documents to iterate over");
            }
            this.hasNext = false;
            return this.doc;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not yet supported");
        }
    }
}

