/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class InstanceRef
implements DocumentRef {
    private static final long serialVersionUID = 1L;
    final String repositoryName;
    final NuxeoPrincipal principal;
    final DocumentRef ref;
    transient DocumentModel referent;

    public InstanceRef(DocumentModel doc, NuxeoPrincipal principal) {
        if (doc.getRef() == null) {
            throw new NullPointerException("document as no reference yet");
        }
        this.referent = doc;
        this.repositoryName = doc.getRepositoryName();
        this.principal = principal;
        this.ref = doc.getRef();
    }

    @Override
    public int type() {
        return -1;
    }

    @Override
    public Object reference() {
        return this.referent;
    }

    private Object readResolve() throws ObjectStreamException {
        boolean started = false;
        if (!TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            started = TransactionHelper.startTransaction();
        }
        try {
            CoreSession session = CoreInstance.getCoreSession(this.repositoryName, this.principal);
            this.referent = session.getDocument(this.ref);
            this.referent.detach(true);
            DocumentModel documentModel = this.referent;
            return documentModel;
        }
        catch (RuntimeException cause) {
            InvalidObjectException error = new InvalidObjectException("Cannot refetch " + String.valueOf(this.ref) + " from " + this.repositoryName);
            error.initCause(cause);
            throw error;
        }
        finally {
            if (started) {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.repositoryName == null ? 0 : this.repositoryName.hashCode());
        result = 31 * result + (this.ref == null ? 0 : this.ref.hashCode());
        result = 31 * result + (this.principal == null ? 0 : this.principal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstanceRef other = (InstanceRef)obj;
        if (this.repositoryName == null ? other.repositoryName != null : !this.repositoryName.equals(other.repositoryName)) {
            return false;
        }
        if (this.ref == null ? other.ref != null : !this.ref.equals(other.ref)) {
            return false;
        }
        return !(this.principal == null ? other.principal != null : !this.principal.equals(other.principal));
    }
}

