/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SortInfo
implements Serializable {
    private static final long serialVersionUID = -5490026543290755342L;
    private static final Logger log = LogManager.getLogger(SortInfo.class);
    public static final String SORT_COLUMN_NAME = "sortColumn";
    public static final String SORT_ASCENDING_NAME = "sortAscending";
    protected String sortColumn;
    protected boolean sortAscending;

    public SortInfo(String sortColumn, boolean sortAscending) {
        if (sortColumn == null) {
            throw new IllegalArgumentException("sortColumn cannot be null");
        }
        this.sortColumn = sortColumn;
        this.sortAscending = sortAscending;
    }

    public boolean getSortAscending() {
        return this.sortAscending;
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(String sortColumn) {
        this.sortColumn = sortColumn;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SortInfo) {
            SortInfo other = (SortInfo)obj;
            if (this.sortColumn != null && this.sortColumn.equals(other.sortColumn)) {
                return this.sortAscending == other.sortAscending;
            }
            if (this.sortColumn == null && other.sortColumn == null) {
                return this.sortAscending == other.sortAscending;
            }
            return false;
        }
        return false;
    }

    public static Map<String, Serializable> asMap(SortInfo sortInfo) {
        if (sortInfo == null) {
            return null;
        }
        HashMap<String, Serializable> res = new HashMap<String, Serializable>();
        res.put(SORT_COLUMN_NAME, (Serializable)((Object)sortInfo.getSortColumn()));
        res.put(SORT_ASCENDING_NAME, Boolean.valueOf(sortInfo.getSortAscending()));
        return res;
    }

    public static SortInfo asSortInfo(Map<String, Serializable> map) {
        if (map == null) {
            return null;
        }
        if (map.containsKey(SORT_COLUMN_NAME) && map.containsKey(SORT_ASCENDING_NAME)) {
            return new SortInfo((String)((Object)map.get(SORT_COLUMN_NAME)), Boolean.parseBoolean(String.valueOf(map.get(SORT_ASCENDING_NAME))));
        }
        log.error("Cannot resolve sort info from map: {}", map);
        return null;
    }

    public String toString() {
        return String.format("SortInfo [sortColumn=%s, sortAscending=%s]", this.sortColumn, this.sortAscending);
    }
}

