/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.NuxeoLoginContext;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class UnrestrictedSessionRunner {
    protected String originatingUsername;
    protected CoreSession session;
    protected final boolean sessionIsAlreadyUnrestricted;
    protected final String repositoryName;
    protected boolean isUnrestricted;

    protected UnrestrictedSessionRunner(CoreSession session) {
        this.session = session;
        this.sessionIsAlreadyUnrestricted = this.checkUnrestricted(session);
        this.repositoryName = this.sessionIsAlreadyUnrestricted ? null : session.getRepositoryName();
        NuxeoPrincipal pal = session.getPrincipal();
        if (pal != null) {
            this.originatingUsername = pal.getName();
        }
    }

    protected UnrestrictedSessionRunner(String repositoryName) {
        this.session = null;
        this.sessionIsAlreadyUnrestricted = false;
        this.repositoryName = repositoryName;
    }

    protected UnrestrictedSessionRunner(String repositoryName, String originatingUser) {
        this.session = null;
        this.sessionIsAlreadyUnrestricted = false;
        this.repositoryName = repositoryName;
        this.originatingUsername = originatingUser;
    }

    public String getOriginatingUsername() {
        return this.originatingUsername;
    }

    public void setOriginatingUsername(String originatingUsername) {
        this.originatingUsername = originatingUsername;
    }

    protected boolean checkUnrestricted(CoreSession session) {
        return session.getPrincipal().isAdministrator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUnrestricted() {
        this.isUnrestricted = true;
        try {
            if (this.sessionIsAlreadyUnrestricted) {
                if (NuxeoPrincipal.isCurrentAdministrator()) {
                    this.run();
                } else {
                    Framework.doPrivileged(this::run);
                }
                return;
            }
            CoreSession baseSession = this.session;
            try (NuxeoLoginContext loginContext = Framework.loginSystem((String)this.originatingUsername);){
                this.session = CoreInstance.getCoreSession(this.repositoryName);
                this.run();
            }
            finally {
                this.session = baseSession;
            }
        }
        catch (Exception e) {
            TransactionHelper.setTransactionRollbackOnly();
            throw e;
        }
        finally {
            this.isUnrestricted = false;
        }
    }

    public abstract void run();
}

