/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.impl.blob.AbstractBlob;

public class URLBlob
extends AbstractBlob
implements Serializable {
    private static final Logger log = LogManager.getLogger(URLBlob.class);
    private static final long serialVersionUID = 1L;
    protected final URL url;
    protected volatile Long length = null;

    public URLBlob(URL url) {
        this(url, null, null);
    }

    public URLBlob(URL url, String mimeType) {
        this(url, mimeType, null);
    }

    public URLBlob(URL url, String mimeType, String encoding) {
        if (url == null) {
            throw new NullPointerException("null url");
        }
        this.url = url;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    @Override
    public InputStream getStream() throws IOException {
        return this.url.openStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLength() {
        if (this.length == null) {
            URLBlob uRLBlob = this;
            synchronized (uRLBlob) {
                if (this.length == null) {
                    try (InputStream in = this.getStream();){
                        this.length = in.transferTo((OutputStream)NullOutputStream.INSTANCE);
                    }
                    catch (IOException e) {
                        log.error("Cannot get blob length for url: {}", (Object)this.url, (Object)e);
                        this.length = -1L;
                    }
                }
            }
        }
        return this.length;
    }
}

