/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl.primitives;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyConversionException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.core.api.model.impl.ScalarProperty;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.schema.types.Field;

public class BlobProperty
extends MapProperty {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "name";
    private static final String MIME_TYPE = "mime-type";
    private static final String ENCODING = "encoding";
    private static final String DIGEST = "digest";
    private static final String LENGTH = "length";
    protected Serializable value;

    public BlobProperty(Property parent, Field field, int flags) {
        super(parent, field, flags);
    }

    @Override
    public Serializable getDefaultValue() {
        return null;
    }

    @Override
    public Serializable internalGetValue() throws PropertyException {
        return this.value;
    }

    @Override
    public void internalSetValue(Serializable value) throws PropertyException {
        this.value = value;
    }

    @Override
    public boolean isNormalized(Object value) {
        return value == null || value instanceof Blob && value instanceof Serializable;
    }

    @Override
    public Serializable normalize(Object value) throws PropertyConversionException {
        if (this.isNormalized(value)) {
            return (Serializable)value;
        }
        throw new PropertyConversionException(value.getClass(), Blob.class);
    }

    @Override
    public <T> T convertTo(Serializable value, Class<T> toType) throws PropertyConversionException {
        if (value == null) {
            return null;
        }
        if (Blob.class.isAssignableFrom(toType)) {
            return (T)value;
        }
        throw new PropertyConversionException(value.getClass(), toType);
    }

    @Override
    public Object newInstance() {
        return new ByteArrayInputStream("".getBytes());
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public void setValue(Object value) throws PropertyException {
        if (value instanceof Map) {
            this.setMap(this.getValue(), (Map)value);
            this.setIsModified();
        } else {
            super.setValue(value);
        }
    }

    @Override
    protected boolean isSameValue(Serializable value1, Serializable value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == value2) {
            return false;
        }
        if (value1 instanceof ManagedBlob && value2 instanceof ManagedBlob) {
            return this.isSameValue((ManagedBlob)((Object)value1), (ManagedBlob)((Object)value2));
        }
        return false;
    }

    protected boolean isSameValue(ManagedBlob value1, ManagedBlob value2) {
        return Objects.equals(value1.getKey(), value2.getKey()) && this.isNullOrSameValue((Serializable)((Object)value1.getMimeType()), (Serializable)((Object)value2.getMimeType())) && this.isNullOrSameValue((Serializable)((Object)value1.getEncoding()), (Serializable)((Object)value2.getEncoding())) && this.isNullOrSameValue((Serializable)((Object)value1.getFilename()), (Serializable)((Object)value2.getFilename())) && this.isNullOrSameValue((Serializable)((Object)value1.getDigest()), (Serializable)((Object)value2.getDigest()));
    }

    protected boolean isNullOrSameValue(Serializable value1, Serializable value2) {
        return value1 == null || value2 == null || value1.equals(value2);
    }

    @Override
    public void init(Serializable value) throws PropertyException {
        if (value == null) {
            return;
        }
        if (value instanceof Blob) {
            this.internalSetValue(value);
        }
        this.removePhantomFlag();
    }

    @Override
    public Serializable getValueForWrite() throws PropertyException {
        return this.getValue();
    }

    @Override
    protected Property internalGetChild(Field field) {
        return new ScalarMemberProperty(this, field, this.isPhantom() ? 16 : 0);
    }

    protected void setMap(Object object, Map<String, Object> value) throws PropertyException {
        if (object == null) {
            throw new NuxeoException("Trying to access a member of a null object");
        }
        if (!(object instanceof Blob)) {
            throw new NuxeoException("Not a Blob: " + String.valueOf(object));
        }
        Blob blob = (Blob)object;
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            String name = entry.getKey();
            Object v = entry.getValue();
            this.setMemberValue(blob, name, v);
        }
    }

    protected void setMemberValue(Blob blob, String name, Object value) throws PropertyNotFoundException {
        if (NAME.equals(name)) {
            blob.setFilename((String)value);
        } else if (MIME_TYPE.equals(name)) {
            blob.setMimeType((String)value);
        } else if (ENCODING.equals(name)) {
            blob.setEncoding((String)value);
        } else if (DIGEST.equals(name)) {
            blob.setDigest((String)value);
        } else {
            throw new PropertyNotFoundException(name);
        }
    }

    protected Object getMemberValue(Object object, String name) throws PropertyException {
        if (object == null) {
            throw new NuxeoException("Trying to access a member of a null object: " + name);
        }
        if (!(object instanceof Blob)) {
            throw new NuxeoException("Not a Blob: " + String.valueOf(object));
        }
        Blob blob = (Blob)object;
        if (NAME.equals(name)) {
            return blob.getFilename();
        }
        if (MIME_TYPE.equals(name)) {
            return blob.getMimeType();
        }
        if (ENCODING.equals(name)) {
            return blob.getEncoding();
        }
        if (DIGEST.equals(name)) {
            return blob.getDigest();
        }
        if (LENGTH.equals(name)) {
            return blob.getLength();
        }
        throw new PropertyNotFoundException(name);
    }

    protected void setMemberValue(Object object, String name, Object value) throws PropertyException {
        if (object == null) {
            throw new NuxeoException("Trying to access a member of a null object: " + name);
        }
        if (!(object instanceof Blob)) {
            throw new NuxeoException("Not a Blob: " + String.valueOf(object));
        }
        Blob blob = (Blob)object;
        this.setMemberValue(blob, name, value);
    }

    @Override
    public boolean isSameAs(Property property) throws PropertyException {
        if (!(property instanceof BlobProperty)) {
            return false;
        }
        BlobProperty other = (BlobProperty)property;
        return Objects.equals(this.getValue(), other.getValue());
    }

    public static class ScalarMemberProperty
    extends ScalarProperty {
        private static final long serialVersionUID = 1L;

        public ScalarMemberProperty(Property parent, Field field, int flags) {
            super(parent, field, flags);
        }

        @Override
        public void internalSetValue(Serializable value) throws PropertyException {
            ((BlobProperty)this.parent).setMemberValue(this.parent.getValue(), this.getName(), (Object)value);
        }

        @Override
        public Serializable internalGetValue() throws PropertyException {
            Object value = ((BlobProperty)this.parent).getMemberValue(this.parent.getValue(), this.getName());
            if (value != null && !(value instanceof Serializable)) {
                throw new PropertyException("Non serializable value: " + String.valueOf(value));
            }
            return (Serializable)value;
        }
    }
}

