/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.nuxeo.common.utils.SizeUtils;
import org.nuxeo.ecm.core.blob.PropertyBasedConfiguration;
import org.nuxeo.runtime.api.Framework;

public class CachingConfiguration
extends PropertyBasedConfiguration {
    public static final String CACHE_SIZE_PROPERTY = "cachesize";
    public static final String CACHE_COUNT_PROPERTY = "cachecount";
    public static final String CACHE_MIN_AGE_PROPERTY = "cacheminage";
    public static final String DEFAULT_CACHE_SIZE = "100 mb";
    public static final String DEFAULT_CACHE_COUNT = "10000";
    public static final String DEFAULT_CACHE_MIN_AGE = "3600";
    public final Path dir;
    public final long maxSize;
    public final long maxCount;
    public final long minAge;

    public CachingConfiguration(String systemPropertyPrefix, Map<String, String> properties) throws IOException {
        super(systemPropertyPrefix, properties);
        this.dir = Framework.createTempDirectory((String)"nxbincache.", (FileAttribute[])new FileAttribute[0]);
        String maxSizeProp = this.getProperty(CACHE_SIZE_PROPERTY, DEFAULT_CACHE_SIZE);
        String maxCountProp = this.getProperty(CACHE_COUNT_PROPERTY, DEFAULT_CACHE_COUNT);
        String minAgeProp = this.getProperty(CACHE_MIN_AGE_PROPERTY, DEFAULT_CACHE_MIN_AGE);
        this.maxSize = SizeUtils.parseSizeInBytes((String)maxSizeProp);
        this.maxCount = Long.parseLong(maxCountProp);
        this.minAge = Long.parseLong(minAgeProp);
    }

    public CachingConfiguration(Path dir, long maxSize, long maxCount, long minAge) {
        super(null, null);
        this.dir = dir;
        this.maxSize = maxSize;
        this.maxCount = maxCount;
        this.minAge = minAge;
    }
}

