/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.util.regex.Pattern;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobContext;
import org.nuxeo.ecm.core.blob.BlobWriteContext;
import org.nuxeo.ecm.core.blob.KeyStrategy;

public class KeyStrategyDocId
implements KeyStrategy {
    protected static final Pattern UUID_REGEX = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}(-.+)?$");
    private static final KeyStrategyDocId INSTANCE = new KeyStrategyDocId();
    protected static final String MAIN_BLOB_XPATH = "content";

    public static KeyStrategyDocId instance() {
        return INSTANCE;
    }

    @Override
    public boolean useDeDuplication() {
        return false;
    }

    @Override
    public String getDigestFromKey(String key) {
        return null;
    }

    @Override
    public BlobWriteContext getBlobWriteContext(BlobContext blobContext) {
        String key = this.getKey(blobContext);
        return new BlobWriteContext(blobContext, null, () -> key, this);
    }

    protected String getKey(BlobContext blobContext) {
        String docId = blobContext.docId;
        if (docId == null) {
            throw new NuxeoException("Missing docId for key strategy");
        }
        String xpath = blobContext.xpath;
        if (MAIN_BLOB_XPATH.equals(xpath)) {
            return docId;
        }
        return docId + "-" + xpath.replace(':', '_').replace('/', '-');
    }

    public boolean equals(Object obj) {
        return obj instanceof KeyStrategyDocId;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public boolean isValidKey(String key) {
        return UUID_REGEX.matcher(key).matches();
    }
}

