/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.LifeCycleException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.schema.DocumentType;

public interface Document {
    public Session getSession();

    public String getName();

    public Long getPos();

    public String getUUID();

    public Document getParent();

    public DocumentType getType();

    public String getPath();

    public void setPropertyValue(String var1, Serializable var2);

    public void setValue(String var1, Object var2) throws PropertyException;

    public Serializable getPropertyValue(String var1);

    public Object getValue(String var1) throws PropertyException;

    public void visitBlobs(Consumer<BlobAccessor> var1) throws PropertyException;

    public String replaceBlobDigest(String var1, String var2, String var3);

    public boolean isFolder();

    public void setReadOnly(boolean var1);

    public boolean isReadOnly();

    public void remove();

    public void remove(NuxeoPrincipal var1);

    public void removeSingleton();

    default public String[] getBlobKeys() {
        throw new UnsupportedOperationException();
    }

    public void makeRecord();

    default public void makeFlexibleRecord() {
        throw new UnsupportedOperationException();
    }

    default public boolean isEnforcedRecord() {
        return this.isRecord() && !this.isFlexibleRecord();
    }

    default public boolean isFlexibleRecord() {
        return false;
    }

    public boolean isRecord();

    public String[] getRetainedProperties();

    public boolean isRetainable(String var1);

    public boolean isRetained(String var1);

    public void setRetainUntil(Calendar var1) throws PropertyException;

    public Calendar getRetainUntil();

    public void setLegalHold(boolean var1);

    public boolean hasLegalHold();

    public boolean isUnderRetentionOrLegalHold();

    @Deprecated
    public boolean isRetentionActive();

    @Deprecated
    public void setRetentionActive(boolean var1);

    public String getLifeCycleState();

    public void setCurrentLifeCycleState(String var1);

    public String getLifeCyclePolicy();

    public void setLifeCyclePolicy(String var1);

    public void followTransition(String var1) throws LifeCycleException;

    public Collection<String> getAllowedStateTransitions();

    public boolean isProxy();

    public String getRepositoryName();

    public void setSystemProp(String var1, Serializable var2);

    public <T extends Serializable> T getSystemProp(String var1, Class<T> var2);

    public String getChangeToken();

    public boolean validateUserVisibleChangeToken(String var1);

    public void markUserChange();

    public void readDocumentPart(DocumentPart var1) throws PropertyException;

    public WriteContext getWriteContext();

    public boolean writeDocumentPart(DocumentPart var1, WriteContext var2, boolean var3) throws PropertyException;

    @Deprecated
    default public boolean writeDocumentPart(DocumentPart dp, WriteContext writeContext) throws PropertyException {
        return this.writeDocumentPart(dp, writeContext, false);
    }

    public Set<String> getAllFacets();

    public String[] getFacets();

    public boolean hasFacet(String var1);

    public boolean addFacet(String var1);

    public boolean removeFacet(String var1);

    public Lock setLock(Lock var1);

    public Lock removeLock(String var1);

    public Lock getLock();

    public Document getChild(String var1);

    public List<Document> getChildren();

    public List<String> getChildrenIds();

    public boolean hasChild(String var1);

    public boolean hasChildren();

    public Document addChild(String var1, String var2);

    public void orderBefore(String var1, String var2);

    public Document checkIn(String var1, String var2);

    public void checkOut();

    public List<String> getVersionsIds();

    public List<Document> getVersions();

    public Document getLastVersion();

    public Document getSourceDocument();

    public void restore(Document var1);

    public Document getVersion(String var1);

    public boolean isVersion();

    public Document getBaseVersion();

    public boolean isCheckedOut();

    public Calendar getVersionCreationDate();

    public String getCheckinComment();

    public String getVersionSeriesId();

    public String getVersionLabel();

    public boolean isLatestVersion();

    public boolean isMajorVersion();

    public boolean isLatestMajorVersion();

    public boolean isVersionSeriesCheckedOut();

    public Document getWorkingCopy();

    public Document getTargetDocument();

    public void setTargetDocument(Document var1);

    public static interface WriteContext {
        public Set<String> getChanges();

        public void flush(Document var1);
    }

    public static interface BlobAccessor {
        public String getXPath();

        public Blob getBlob();

        default public void setBlob(Blob blob) {
            this.setBlob(blob, true);
        }

        public void setBlob(Blob var1, boolean var2);
    }
}

