/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;

public final class DocumentModelUtils {
    private static final Logger log = LogManager.getLogger(DocumentModelUtils.class);

    private DocumentModelUtils() {
    }

    public static String encodePropertyName(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        String[] items = propertyName.split(":");
        return DocumentModelUtils.join(items, "/");
    }

    public static String decodePropertyName(String propertyPath) {
        if (propertyPath == null) {
            return null;
        }
        String[] items = propertyPath.split("/");
        return DocumentModelUtils.join(items, ".");
    }

    public static Object getPropertyValue(DocumentModel doc, String propertyName) {
        try {
            String schemaName = DocumentModelUtils.getSchemaName(propertyName);
            String fieldName = DocumentModelUtils.getFieldName(propertyName);
            return doc.getProperty(schemaName, fieldName);
        }
        catch (PropertyException e) {
            log.warn("Error trying to get property: {}. {}", (Object)propertyName, (Object)e.getMessage(), (Object)(log.isDebugEnabled() ? e : null));
            return null;
        }
    }

    public static Object getComplexPropertyValue(DocumentModel doc, String propertyPath) {
        try {
            return doc.getPropertyValue(propertyPath);
        }
        catch (PropertyException e) {
            return null;
        }
    }

    public static String getSchemaName(String propertyName) {
        String[] s = propertyName.split(":");
        if (s.length != 2) {
            throw new IllegalArgumentException("offending value: " + propertyName);
        }
        String prefix = s[0];
        Schema schema = null;
        SchemaManager tm = (SchemaManager)Framework.getService(SchemaManager.class);
        schema = tm.getSchemaFromPrefix(prefix);
        if (schema == null) {
            return prefix;
        }
        return schema.getName();
    }

    public static String getFieldName(String propertyName) {
        int index = propertyName.indexOf(":");
        if (index == -1) {
            throw new IllegalArgumentException("offending value: " + propertyName);
        }
        return propertyName.substring(index + 1);
    }

    private static String join(String[] items, String sep) {
        StringBuilder sb = new StringBuilder();
        int max = items.length - 1;
        for (int i = 0; i < items.length; ++i) {
            sb.append(items[i]);
            if (i >= max) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static Map<String, Object> getProperties(DocumentModel docModel) {
        String[] schemas = docModel.getSchemas();
        if (schemas == null) {
            throw new IllegalStateException("schemas are not declared for docModel " + String.valueOf(docModel));
        }
        HashMap<String, Object> allProps = new HashMap<String, Object>();
        for (String schemaName : schemas) {
            Map<String, Object> props = docModel.getProperties(schemaName);
            allProps.putAll(props);
        }
        return allProps;
    }
}

