/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.fsexporter;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.io.fsexporter.DefaultExporterPlugin;

public class DriveLikeExporterPlugin
extends DefaultExporterPlugin {
    public static final Pattern FORBIDDEN_CHAR_PATTERN = Pattern.compile("[\\\"|*/:<>?\\\\]", 8);

    @Override
    public File serialize(CoreSession session, DocumentModel docfrom, String fsPath) throws IOException {
        BlobHolder myblobholder;
        File folder = null;
        File newFolder = null;
        folder = new File(fsPath);
        if (!folder.exists()) {
            folder.mkdir();
        }
        if ("/".equals(docfrom.getPathAsString())) {
            return folder;
        }
        if (docfrom.isFolder()) {
            String fileName = this.encodeFilename(StringUtils.isNotBlank((CharSequence)docfrom.getTitle()) ? docfrom.getTitle() : docfrom.getName());
            newFolder = this.avoidingCollision(new File(fsPath, fileName));
            newFolder.mkdir();
        }
        if ((myblobholder = (BlobHolder)docfrom.getAdapter(BlobHolder.class)) != null && myblobholder.getBlob() != null) {
            Blob blob = myblobholder.getBlob();
            String filename = blob.getFilename();
            File target = this.avoidingCollision(new File(folder, filename));
            blob.transferTo(target);
        }
        if (newFolder != null) {
            folder = newFolder;
        }
        return folder;
    }

    protected File avoidingCollision(File file) {
        int i = 1;
        while (file.exists()) {
            String name = file.getName();
            if (file.isFile() && name.indexOf(".") > 0) {
                String namePart = name.substring(0, name.indexOf("."));
                String extPart = name.substring(name.indexOf("."));
                file = new File(file.getParent(), namePart + "_" + i++ + extPart);
                continue;
            }
            file = new File(file.getAbsolutePath() + "_" + i++);
        }
        return file;
    }

    protected String encodeFilename(String filename) {
        return FORBIDDEN_CHAR_PATTERN.matcher(filename).replaceAll("-");
    }
}

