/*
 * Decompiled with CFR 0.152.
 */
package com.iss.nuxeo.bulkimport.jaxrs;

import com.iss.nuxeo.bulkimport.ImportContext;
import com.iss.nuxeo.bulkimport.source.FileSourceManager;
import com.iss.nuxeo.bulkimport.source.FileSourceProvider;
import com.iss.nuxeo.bulkimport.task.TaskInfo;
import com.iss.nuxeo.bulkimport.task.TaskPool;
import java.util.Date;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.importer.executor.jaxrs.HttpFileImporterExecutor;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="BulkImportTask")
@Path(value="tasks")
@Produces(value={"text/plain"})
public class BulkImportTask
extends DefaultObject {
    private static final Log log = LogFactory.getLog(BulkImportTask.class);

    @GET
    @Produces(value={"application/json; charset=UTF-8"})
    public List<TaskInfo> listTasks() {
        return TaskPool.get().listTasks();
    }

    @GET
    @Path(value="run")
    @Produces(value={"application/json; charset=UTF-8"})
    public synchronized Response runImport(@QueryParam(value="inputPath") String inputPath, @QueryParam(value="targetPath") String targetPath, @QueryParam(value="batchSize") Integer batchSize, @QueryParam(value="nbThreads") Integer nbThreads, @QueryParam(value="interactive") Boolean interactive, @QueryParam(value="transactionTimeout") Integer transactionTimeout, @QueryParam(value="enableLogging") Boolean enableLogging) {
        ImportContext icxt = new ImportContext();
        icxt.setPrincipal(this.ctx.getPrincipal());
        FileSourceProvider provider = this.getFileSetProvider(icxt);
        boolean validInputPath = provider.isValidSublocations(inputPath, false);
        if (!validInputPath) {
            return Response.status((int)400).entity((Object)("Invalid input path [" + inputPath + "]")).build();
        }
        HttpFileImporterExecutor executor = new HttpFileImporterExecutor();
        TaskInfo info = TaskPool.get().createTask(executor);
        if (info == null) {
            return Response.status((int)503).entity((Object)("The current running tasks has reached its maximum threshold " + TaskPool.get().getMaxTaskSize())).build();
        }
        if (enableLogging.booleanValue()) {
            executor.enableLogging();
        }
        String sourcePath = provider.createSourceNodePath(StringUtils.appendIfMissing((String)inputPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]));
        String status = executor.run(null, null, sourcePath, targetPath, Boolean.valueOf(true), batchSize, nbThreads, interactive, transactionTimeout);
        info.setStartDate(new Date());
        info.setSource(inputPath);
        info.setTarget(targetPath);
        info.setUser(this.getContext().getPrincipal().getName());
        info.setStatus(status);
        if (log.isInfoEnabled()) {
            log.info((Object)("new bulk import task: " + info));
        }
        return Response.status((int)202).entity((Object)info).build();
    }

    @Path(value="{taskId}/log")
    @GET
    @Produces(value={"text/plain"})
    public Response getLog(@PathParam(value="taskId") String taskId) {
        HttpFileImporterExecutor task = TaskPool.get().getTaskExecutor(taskId);
        if (task == null) {
            return Response.status((int)404).entity((Object)("The task [" + taskId + "] has finished or doesn't exit")).build();
        }
        return Response.ok().entity((Object)task.getLogAsString()).build();
    }

    @GET
    @Path(value="{taskId}/logActivate")
    public Response enableLogging(@PathParam(value="taskId") String taskId) {
        HttpFileImporterExecutor task = TaskPool.get().getTaskExecutor(taskId);
        if (task == null) {
            return Response.status((int)404).entity((Object)("The task [" + taskId + "] has finished or doesn't exit")).build();
        }
        return Response.ok().entity((Object)task.enableLogging()).build();
    }

    @GET
    @Path(value="{taskId}/logDesactivate")
    public Response disableLogging(@PathParam(value="taskId") String taskId) {
        HttpFileImporterExecutor task = TaskPool.get().getTaskExecutor(taskId);
        if (task == null) {
            return Response.status((int)404).entity((Object)("The task [" + taskId + "] has finished or doesn't exit")).build();
        }
        return Response.ok().entity((Object)task.disableLogging()).build();
    }

    @GET
    @Path(value="{taskId}/status")
    public Response getStatus(@PathParam(value="taskId") String taskId) {
        HttpFileImporterExecutor task = TaskPool.get().getTaskExecutor(taskId);
        if (task == null) {
            return Response.status((int)404).entity((Object)("The task [" + taskId + "] has finished or doesn't exit")).build();
        }
        return Response.ok().entity((Object)task.getStatus()).build();
    }

    @GET
    @Path(value="{taskId}/running")
    public Response running(@PathParam(value="taskId") String taskId) {
        HttpFileImporterExecutor task;
        if (log.isDebugEnabled()) {
            log.debug((Object)("check task running status for " + taskId));
        }
        if ((task = TaskPool.get().getTaskExecutor(taskId)) == null) {
            return Response.ok().entity((Object)"false").build();
        }
        return Response.ok().entity((Object)task.running()).build();
    }

    @GET
    @Path(value="{taskId}/kill")
    public Response kill(@PathParam(value="taskId") String taskId) {
        HttpFileImporterExecutor task = TaskPool.get().getTaskExecutor(taskId);
        if (task == null) {
            return Response.status((int)404).entity((Object)("The task [" + taskId + "] has finished or doesn't exit")).build();
        }
        return Response.ok().entity((Object)task.kill()).build();
    }

    @GET
    @Path(value="{taskId}/waitForAsyncJobs")
    public Response waitForAsyncJobs(@PathParam(value="taskId") String taskId, @QueryParam(value="timeoutInSeconds") Integer timeoutInSeconds) {
        HttpFileImporterExecutor task = TaskPool.get().getTaskExecutor(taskId);
        if (task == null) {
            return Response.status((int)404).entity((Object)("The task [" + taskId + "] has finished or doesn't exit")).build();
        }
        return task.waitForAsyncJobs(timeoutInSeconds);
    }

    protected FileSourceProvider getFileSetProvider(ImportContext icxt) {
        FileSourceManager providers = (FileSourceManager)Framework.getService(FileSourceManager.class);
        return providers.getFileSourceProvider(icxt);
    }
}

