/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.properties;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;

public class MetadataFile {
    private static final Log log = LogFactory.getLog(MetadataFile.class);
    protected DocumentModel doc;
    protected Properties metadataProperties = new Properties();

    public static MetadataFile createFromDocument(DocumentModel doc) {
        MetadataFile mdFile = new MetadataFile(doc);
        mdFile.load();
        return mdFile;
    }

    public static MetadataFile createFromSchemasAndProperties(DocumentModel doc, List<String> allPropertiesSchemas, List<String> properties) {
        MetadataFile mdFile = new MetadataFile(doc);
        mdFile.load(allPropertiesSchemas, properties);
        return mdFile;
    }

    public static MetadataFile createFromSchemas(DocumentModel doc, List<String> allPropertiesSchemas) {
        return MetadataFile.createFromSchemasAndProperties(doc, allPropertiesSchemas, Collections.emptyList());
    }

    public static MetadataFile createFromProperties(DocumentModel doc, List<String> properties) {
        return MetadataFile.createFromSchemasAndProperties(doc, Collections.emptyList(), properties);
    }

    protected MetadataFile(DocumentModel doc) {
        this.doc = doc;
    }

    protected void load(List<String> allPropertiesSchemas, List<String> properties) {
        if (!this.metadataProperties.isEmpty()) {
            return;
        }
        for (String schema : allPropertiesSchemas) {
            this.addAllProperties(schema);
        }
        for (String property : properties) {
            try {
                this.addProperty(property, this.doc.getPropertyValue(property));
            }
            catch (PropertyException e) {
                String message = String.format("Property '%s' not found on document type: %s. Skipping it.", property, this.doc.getType());
                log.debug((Object)message);
            }
        }
    }

    protected void addAllProperties(String schema) {
        DataModel dm = this.doc.getDataModel(schema);
        if (dm != null) {
            for (Map.Entry entry : dm.getMap().entrySet()) {
                Object value = entry.getValue();
                String propertyKey = (String)entry.getKey();
                this.addProperty(this.computePropertyKey(propertyKey, schema), value);
            }
        }
    }

    public void addProperty(String propertyKey, Object value) {
        if (value instanceof String) {
            this.metadataProperties.put(propertyKey, value);
        } else if (value instanceof List) {
            try {
                ArrayList<String> list = (ArrayList<String>)value;
                if (!list.isEmpty()) {
                    if (list.size() == 1) {
                        list = new ArrayList<String>(list);
                        list.add("");
                    }
                    this.metadataProperties.put(propertyKey, String.join((CharSequence)"|", list));
                }
            }
            catch (ClassCastException list) {}
        } else if (value instanceof String[]) {
            List<String> list = Arrays.asList((String[])value);
            if (!list.isEmpty()) {
                if (list.size() == 1) {
                    list = new ArrayList<String>(list);
                    list.add("");
                }
                this.metadataProperties.put(propertyKey, String.join((CharSequence)"||", list));
            }
        } else if (value instanceof Calendar) {
            this.metadataProperties.put(propertyKey, new DateType().encode(value));
        } else if (value instanceof Number) {
            this.metadataProperties.put(propertyKey, value.toString());
        }
    }

    protected String computePropertyKey(String propertyKey, String schema) {
        if (!propertyKey.contains(":")) {
            propertyKey = schema + ":" + propertyKey;
        }
        return propertyKey;
    }

    protected void load() {
        for (String schema : this.doc.getSchemas()) {
            this.addAllProperties(schema);
        }
    }

    public void writeTo(File file) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.metadataProperties.store(fos, null);
        }
        catch (IOException e) {
            throw new NuxeoException("Unable to write the metadata properties to " + file.getAbsolutePath(), (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

