/*
 * Decompiled with CFR 0.152.
 */
package com.iss.nuxeo.bulkimport.source;

import com.iss.nuxeo.bulkimport.source.FileSource;
import com.iss.nuxeo.bulkimport.source.FileSourceProvider;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractFileSourceProvider
implements FileSourceProvider {
    protected String id;
    protected FileSource fileset;

    @Override
    public void initialize(String id, Map<String, String> properties) {
        this.id = id;
        this.fileset = new FileSource();
        String root = properties.getOrDefault("location.root", "/");
        this.fileset.setRootLocation(StringUtils.appendIfMissing((String)root, (CharSequence)"/", (CharSequence[])new CharSequence[0]));
        this.fileset.setCaseSensitive(properties.getOrDefault("caseSensitive", "true"));
        this.fileset.setExcludes(properties.get("excludes"));
        this.fileset.setIncludes(properties.get("includes"));
        this.fileset.setMetadataFileExtensions(properties.get("meta.extensions"));
    }

    @Override
    public String createSourceNodePath(String location) {
        return this.id + ":" + location;
    }

    @Override
    public String getSourceRoot() {
        return this.fileset.getRootLocation();
    }

    @Override
    public boolean isValidSublocations(String location, boolean acceptRoot) {
        if (StringUtils.isBlank((CharSequence)location)) {
            return false;
        }
        String root = this.getSourceRoot();
        if (acceptRoot && location.equals(location)) {
            return true;
        }
        return location.startsWith(root);
    }

    protected String getLastPathName(String location) {
        String path = StringUtils.removeEnd((String)location, (String)"/");
        int index = path.lastIndexOf("/");
        return path.substring(index + 1);
    }
}

