/*
 * Decompiled with CFR 0.152.
 */
package com.iss.nuxeo.bulkimport.source;

import com.iss.nuxeo.bulkimport.common.StringTool;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FileSource {
    private boolean caseSensitive;
    private String rootLocation;
    private Set<String> excludes = new HashSet<String>();
    private Set<String> includes = new HashSet<String>();
    private Set<String> metadataFileExtensions = new HashSet<String>();

    public void setRootLocation(String rootLocation) {
        this.rootLocation = rootLocation;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(String caseSensitive) {
        this.caseSensitive = "true".equalsIgnoreCase(caseSensitive);
    }

    public String getRootLocation() {
        return this.rootLocation;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        if (StringUtils.isBlank((CharSequence)excludes)) {
            return;
        }
        this.excludes = Arrays.stream(excludes.split(",")).filter(StringUtils::isNotBlank).map(c -> c.trim()).collect(Collectors.toSet());
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        if (StringUtils.isBlank((CharSequence)includes)) {
            return;
        }
        this.includes = Arrays.stream(includes.split(",")).filter(StringUtils::isNotBlank).map(c -> c.trim()).collect(Collectors.toSet());
    }

    public Set<String> getMetadataFileExtensions() {
        return this.metadataFileExtensions;
    }

    public void setMetadataFileExtensions(String metadataFileExtensions) {
        if (StringUtils.isBlank((CharSequence)metadataFileExtensions)) {
            return;
        }
        this.metadataFileExtensions = Arrays.stream(metadataFileExtensions.split(",")).filter(StringUtils::isNotBlank).map(c -> c.trim()).collect(Collectors.toSet());
    }

    public String toString() {
        return StringTool.toJson(this);
    }
}

