/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.EncryptionEntities;
import com.amazonaws.services.cloudfront.model.EncryptionEntity;
import com.amazonaws.services.cloudfront.model.transform.EncryptionEntityStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class EncryptionEntitiesStaxUnmarshaller
implements Unmarshaller<EncryptionEntities, StaxUnmarshallerContext> {
    private static EncryptionEntitiesStaxUnmarshaller instance;

    public EncryptionEntities unmarshall(StaxUnmarshallerContext context) throws Exception {
        EncryptionEntities encryptionEntities = new EncryptionEntities();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return encryptionEntities;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    encryptionEntities.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    encryptionEntities.withItems(new ArrayList<EncryptionEntity>());
                    continue;
                }
                if (!context.testExpression("Items/EncryptionEntity", targetDepth)) continue;
                encryptionEntities.withItems(EncryptionEntityStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return encryptionEntities;
    }

    public static EncryptionEntitiesStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EncryptionEntitiesStaxUnmarshaller();
        }
        return instance;
    }
}

