/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.importer.base.GenericMultiThreadedImporter;
import org.nuxeo.ecm.platform.importer.factories.ImporterDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.filter.ImportingDocumentFilter;
import org.nuxeo.ecm.platform.importer.listener.ImporterListener;
import org.nuxeo.ecm.platform.importer.log.ImporterLogger;
import org.nuxeo.ecm.platform.importer.source.SourceNode;
import org.nuxeo.ecm.platform.importer.threading.ImporterThreadingPolicy;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class GenericThreadedImportTask
implements Runnable {
    public static final String DOC_IMPORTED_EVENT = "documentImportedWithPlatformImporter";
    private static final Log log = LogFactory.getLog(GenericThreadedImportTask.class);
    protected static int taskCounter = 0;
    protected boolean isRunning = false;
    protected long uploadedFiles = 0L;
    protected long uploadedKO;
    protected int batchSize;
    protected CoreSession session;
    protected DocumentModel rootDoc;
    protected SourceNode rootSource;
    protected Boolean skipContainerCreation = false;
    protected Boolean isRootTask = false;
    protected String taskId = null;
    public static final int TX_TIMEOUT = 600;
    protected int transactionTimeout = 600;
    protected ImporterThreadingPolicy threadPolicy;
    protected ImporterDocumentModelFactory factory;
    protected String jobName;
    protected List<ImporterListener> listeners = new ArrayList<ImporterListener>();
    protected List<ImportingDocumentFilter> importingDocumentFilters = new ArrayList<ImportingDocumentFilter>();
    protected String repositoryName;
    protected ImporterLogger rsLogger = null;

    private static synchronized int getNextTaskId() {
        return ++taskCounter;
    }

    protected GenericThreadedImportTask(CoreSession session) {
        this.session = session;
        this.uploadedFiles = 0L;
        this.taskId = "T" + GenericThreadedImportTask.getNextTaskId();
    }

    protected GenericThreadedImportTask(CoreSession session, SourceNode rootSource, DocumentModel rootDoc, boolean skipContainerCreation, ImporterLogger rsLogger, int batchSize, ImporterDocumentModelFactory factory, ImporterThreadingPolicy threadPolicy) {
        this.rsLogger = rsLogger;
        this.session = session;
        this.batchSize = batchSize;
        this.uploadedFiles = 0L;
        this.taskId = "T" + GenericThreadedImportTask.getNextTaskId();
        this.rootSource = rootSource;
        this.rootDoc = rootDoc;
        this.skipContainerCreation = skipContainerCreation;
        this.factory = factory;
        this.threadPolicy = threadPolicy;
        if (rootSource == null) {
            throw new IllegalArgumentException("source node must be specified");
        }
    }

    public GenericThreadedImportTask(String repositoryName, SourceNode rootSource, DocumentModel rootDoc, boolean skipContainerCreation, ImporterLogger rsLogger, int batchSize, ImporterDocumentModelFactory factory, ImporterThreadingPolicy threadPolicy, String jobName) {
        this(null, rootSource, rootDoc, skipContainerCreation, rsLogger, batchSize, factory, threadPolicy);
        this.jobName = jobName;
        this.repositoryName = repositoryName;
    }

    protected CoreSession getCoreSession() {
        return this.session;
    }

    protected void commit() {
        this.commit(false);
    }

    protected void commit(boolean force) {
        ++this.uploadedFiles;
        if (this.uploadedFiles % 10L == 0L) {
            GenericMultiThreadedImporter.addCreatedDoc(this.taskId, this.uploadedFiles);
        }
        if (this.uploadedFiles % (long)this.batchSize == 0L || force) {
            Stopwatch stopwatch = SimonManager.getStopwatch((String)"org.nuxeo.ecm.platform.importer.session_save");
            Split split = stopwatch.start();
            this.fslog("Committing Core Session after " + this.uploadedFiles + " files", true);
            this.session.save();
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction((int)this.transactionTimeout);
            split.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocumentModel doCreateFolderishNode(DocumentModel parent, SourceNode node) {
        if (!this.shouldImportDocument(node)) {
            return null;
        }
        Stopwatch stopwatch = SimonManager.getStopwatch((String)"org.nuxeo.ecm.platform.importer.create_folder");
        Split split = stopwatch.start();
        DocumentModel folder = null;
        try {
            folder = this.getFactory().createFolderishNode(this.session, parent, node);
        }
        catch (IOException e) {
            String errorMsg = "Unable to create folderish document for " + node.getSourcePath() + ":" + e + (e.getCause() != null ? e.getCause() : "");
            this.fslog(errorMsg, true);
            log.error((Object)errorMsg);
            boolean shouldImportTaskContinue = this.getFactory().processFolderishNodeCreationError(this.session, parent, node);
            if (!shouldImportTaskContinue) {
                throw new NuxeoException((Throwable)e);
            }
        }
        finally {
            split.stop();
        }
        if (folder != null) {
            String parentPath = parent == null ? "null" : parent.getPathAsString();
            this.fslog("Created Folder " + folder.getName() + " at " + parentPath, true);
            this.commit();
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocumentModel doCreateLeafNode(DocumentModel parent, SourceNode node) throws IOException {
        if (!this.shouldImportDocument(node)) {
            return null;
        }
        Stopwatch stopwatch = SimonManager.getStopwatch((String)"org.nuxeo.ecm.platform.importer.create_leaf");
        Split split = stopwatch.start();
        DocumentModel leaf = null;
        try {
            leaf = this.getFactory().createLeafNode(this.session, parent, node);
        }
        catch (IOException e) {
            String errMsg = "Unable to create leaf document for " + node.getSourcePath() + ":" + e + (e.getCause() != null ? e.getCause() : "");
            this.fslog(errMsg, true);
            log.error((Object)errMsg);
            boolean shouldImportTaskContinue = this.getFactory().processLeafNodeCreationError(this.session, parent, node);
            if (!shouldImportTaskContinue) {
                throw new NuxeoException((Throwable)e);
            }
        }
        finally {
            split.stop();
        }
        BlobHolder bh = node.getBlobHolder();
        if (leaf != null && bh != null) {
            Blob blob = bh.getBlob();
            if (blob != null) {
                long fileSize = blob.getLength();
                String fileName = blob.getFilename();
                if (fileSize > 0L) {
                    long kbSize = fileSize / 1024L;
                    String parentPath = parent == null ? "null" : parent.getPathAsString();
                    this.fslog("Created doc " + leaf.getName() + " at " + parentPath + " with file " + fileName + " of size " + kbSize + "KB", true);
                }
                this.uploadedKO += fileSize;
            }
            EventProducer eventProducer = (EventProducer)Framework.getService(EventProducer.class);
            DocumentEventContext eventContext = new DocumentEventContext(this.session, this.session.getPrincipal(), leaf);
            Event event = eventContext.newEvent(DOC_IMPORTED_EVENT);
            eventProducer.fireEvent(event);
            this.commit();
        }
        return leaf;
    }

    protected boolean shouldImportDocument(SourceNode node) {
        for (ImportingDocumentFilter importingDocumentFilter : this.importingDocumentFilters) {
            if (importingDocumentFilter.shouldImportDocument(node)) continue;
            return false;
        }
        return true;
    }

    protected GenericThreadedImportTask createNewTask(DocumentModel parent, SourceNode node, ImporterLogger log, Integer batchSize) {
        GenericThreadedImportTask newTask = new GenericThreadedImportTask(this.repositoryName, node, parent, this.skipContainerCreation, log, batchSize, this.factory, this.threadPolicy, null);
        newTask.addListeners(this.listeners);
        newTask.addImportingDocumentFilters(this.importingDocumentFilters);
        return newTask;
    }

    protected GenericThreadedImportTask createNewTaskIfNeeded(DocumentModel parent, SourceNode node) {
        if (this.isRootTask.booleanValue()) {
            this.isRootTask = false;
            return null;
        }
        int scheduledTasks = GenericMultiThreadedImporter.getExecutor().getQueue().size();
        boolean createTask = this.getThreadPolicy().needToCreateThreadAfterNewFolderishNode(parent, node, this.uploadedFiles, this.batchSize, scheduledTasks);
        if (createTask) {
            GenericThreadedImportTask newTask = this.createNewTask(parent, node, this.rsLogger, this.batchSize);
            newTask.setBatchSize(this.getBatchSize());
            newTask.setSkipContainerCreation(true);
            newTask.setTransactionTimeout(this.transactionTimeout);
            return newTask;
        }
        return null;
    }

    protected void recursiveCreateDocumentFromNode(DocumentModel parent, SourceNode node) throws IOException {
        if (this.getFactory().isTargetDocumentModelFolderish(node)) {
            DocumentModel folder;
            Boolean newThread = false;
            if (this.skipContainerCreation.booleanValue()) {
                folder = parent;
                this.skipContainerCreation = false;
                newThread = true;
            } else {
                folder = this.doCreateFolderishNode(parent, node);
                if (folder == null) {
                    return;
                }
            }
            GenericThreadedImportTask task = null;
            if (!newThread.booleanValue()) {
                task = this.createNewTaskIfNeeded(folder, node);
            }
            if (task != null) {
                this.commit(true);
                try {
                    GenericMultiThreadedImporter.getExecutor().execute(task);
                }
                catch (RejectedExecutionException e) {
                    log.error((Object)"Import task rejected", (Throwable)e);
                }
            } else {
                Stopwatch stopwatch = SimonManager.getStopwatch((String)"org.nuxeo.ecm.platform.importer.node_get_children");
                Split split = stopwatch.start();
                List<SourceNode> nodes = node.getChildren();
                split.stop();
                if (nodes != null) {
                    for (SourceNode child : nodes) {
                        this.recursiveCreateDocumentFromNode(folder, child);
                    }
                }
            }
        } else {
            this.doCreateLeafNode(parent, node);
        }
    }

    public void setInputSource(SourceNode node) {
        this.rootSource = node;
    }

    public void setTargetFolder(DocumentModel rootDoc) {
        this.rootDoc = rootDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        GenericThreadedImportTask genericThreadedImportTask = this;
        synchronized (genericThreadedImportTask) {
            return this.isRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        GenericThreadedImportTask genericThreadedImportTask = this;
        synchronized (genericThreadedImportTask) {
            if (this.isRunning) {
                throw new IllegalStateException("Task already running");
            }
            this.isRunning = true;
            if (this.rootSource == null) {
                this.isRunning = false;
                throw new IllegalArgumentException("source node must be specified");
            }
        }
        TransactionHelper.startTransaction((int)this.transactionTimeout);
        boolean completedAbruptly = true;
        try (Object closeableCoreSession = CoreInstance.openCoreSessionSystem((String)this.repositoryName);){
            this.session = closeableCoreSession;
            log.info((Object)"Starting new import task");
            Framework.doPrivileged(() -> {
                if (this.rootDoc != null) {
                    this.rootDoc = this.session.getDocument(this.rootDoc.getRef());
                }
                try {
                    this.recursiveCreateDocumentFromNode(this.rootDoc, this.rootSource);
                }
                catch (IOException e) {
                    throw new NuxeoException((Throwable)e);
                }
                this.session.save();
            });
            GenericMultiThreadedImporter.addCreatedDoc(this.taskId, this.uploadedFiles);
            completedAbruptly = false;
        }
        catch (Exception e) {
            log.error((Object)"Error during import", (Throwable)e);
            ExceptionUtils.checkInterrupt((Exception)e);
            this.notifyImportError();
        }
        finally {
            log.info((Object)"End of task");
            this.session = null;
            if (completedAbruptly) {
                TransactionHelper.setTransactionRollbackOnly();
            }
            TransactionHelper.commitOrRollbackTransaction();
            GenericThreadedImportTask genericThreadedImportTask2 = this;
            synchronized (genericThreadedImportTask2) {
                this.isRunning = false;
            }
        }
    }

    protected void fslog(String msg, boolean debug) {
        if (debug) {
            this.rsLogger.debug(msg);
        } else {
            this.rsLogger.info(msg);
        }
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setSkipContainerCreation(Boolean skipContainerCreation) {
        this.skipContainerCreation = skipContainerCreation;
    }

    public void setRootTask() {
        this.isRootTask = true;
        taskCounter = 0;
        this.taskId = "T0";
    }

    protected ImporterThreadingPolicy getThreadPolicy() {
        return this.threadPolicy;
    }

    protected ImporterDocumentModelFactory getFactory() {
        return this.factory;
    }

    public void addImportingDocumentFilters(ImportingDocumentFilter ... importingDocumentFilters) {
        this.addImportingDocumentFilters(Arrays.asList(importingDocumentFilters));
    }

    public void addImportingDocumentFilters(Collection<ImportingDocumentFilter> importingDocumentFilters) {
        this.importingDocumentFilters.addAll(importingDocumentFilters);
    }

    public void addListeners(ImporterListener ... listeners) {
        this.addListeners(Arrays.asList(listeners));
    }

    public void addListeners(Collection<ImporterListener> listeners) {
        this.listeners.addAll(listeners);
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout < 1 ? 600 : transactionTimeout;
    }

    protected void notifyImportError() {
        for (ImporterListener listener : this.listeners) {
            listener.importError();
        }
    }

    protected void setRootDoc(DocumentModel rootDoc) {
        this.rootDoc = rootDoc;
    }

    protected void setRootSource(SourceNode rootSource) {
        this.rootSource = rootSource;
    }

    protected void setFactory(ImporterDocumentModelFactory factory) {
        this.factory = factory;
    }

    protected void setRsLogger(ImporterLogger rsLogger) {
        this.rsLogger = rsLogger;
    }

    protected void setThreadPolicy(ImporterThreadingPolicy threadPolicy) {
        this.threadPolicy = threadPolicy;
    }

    protected void setJobName(String jobName) {
        this.jobName = jobName;
    }
}

