/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.blob;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.RFC2231;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.binary.BinaryBlobProvider;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.ecm.core.blob.binary.CachingBinaryManager;
import org.nuxeo.ecm.core.blob.binary.FileStorage;
import org.nuxeo.ecm.core.io.download.DownloadHelper;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractCloudBinaryManager
extends CachingBinaryManager
implements BlobProvider {
    private static final Log log = LogFactory.getLog(AbstractCloudBinaryManager.class);
    protected Map<String, String> properties;
    protected boolean directDownload = false;
    protected int directDownloadExpire;
    protected boolean transientFlag;
    protected String namespace;
    public static final String CACHE_SIZE_PROPERTY = "cachesize";
    public static final String CACHE_COUNT_PROPERTY = "cachecount";
    public static final String CACHE_MIN_AGE_PROPERTY = "cacheminage";
    public static final String DEFAULT_CACHE_SIZE = "100 mb";
    public static final String DEFAULT_CACHE_COUNT = "10000";
    public static final String DEFAULT_CACHE_MIN_AGE = "3600";
    public static final String DIRECTDOWNLOAD_PROPERTY = "directdownload";
    public static final String DEFAULT_DIRECTDOWNLOAD = "false";
    public static final String DIRECTDOWNLOAD_EXPIRE_PROPERTY = "directdownload.expire";
    public static final int DEFAULT_DIRECTDOWNLOAD_EXPIRE = 3600;

    protected abstract String getSystemPropertyPrefix();

    protected abstract FileStorage getFileStorage();

    protected abstract BinaryGarbageCollector instantiateGarbageCollector();

    public abstract void removeBinaries(Collection<String> var1);

    protected abstract void setupCloudClient() throws IOException;

    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        super.initialize(blobProviderId, properties);
        this.properties = properties;
        this.directDownload = Boolean.parseBoolean(this.getProperty(DIRECTDOWNLOAD_PROPERTY, DEFAULT_DIRECTDOWNLOAD));
        this.directDownloadExpire = this.getIntProperty(DIRECTDOWNLOAD_EXPIRE_PROPERTY);
        if (this.directDownloadExpire < 0) {
            this.directDownloadExpire = 3600;
        }
        this.transientFlag = Boolean.parseBoolean(this.getProperty("transient"));
        this.namespace = this.getProperty("namespace");
        this.setupCloudClient();
        String cacheSizeStr = this.getProperty(CACHE_SIZE_PROPERTY, DEFAULT_CACHE_SIZE);
        String cacheCountStr = this.getProperty(CACHE_COUNT_PROPERTY, DEFAULT_CACHE_COUNT);
        String minAgeStr = this.getProperty(CACHE_MIN_AGE_PROPERTY, DEFAULT_CACHE_MIN_AGE);
        this.initializeCache(cacheSizeStr, cacheCountStr, minAgeStr, this.getFileStorage());
        this.garbageCollector = this.instantiateGarbageCollector();
    }

    public BinaryManager getBinaryManager() {
        return this;
    }

    public Blob readBlob(BlobInfo blobInfo) throws IOException {
        return new BinaryBlobProvider((BinaryManager)this).readBlob(blobInfo);
    }

    public String writeBlob(Blob blob) throws IOException {
        return new BinaryBlobProvider((BinaryManager)this).writeBlob(blob);
    }

    public boolean performsExternalAccessControl(BlobInfo blobInfo) {
        return new BinaryBlobProvider((BinaryManager)this).performsExternalAccessControl(blobInfo);
    }

    public boolean supportsUserUpdate() {
        return this.supportsUserUpdateDefaultTrue();
    }

    protected boolean supportsUserUpdateDefaultTrue() {
        return !Boolean.parseBoolean(this.properties.get("preventUserUpdate"));
    }

    public URI getURI(ManagedBlob blob, BlobManager.UsageHint hint, HttpServletRequest servletRequest) throws IOException {
        if (hint != BlobManager.UsageHint.DOWNLOAD || !this.isDirectDownload()) {
            return null;
        }
        String digest = blob.getKey();
        int colon = digest.indexOf(58);
        if (colon >= 0) {
            digest = digest.substring(colon + 1);
        }
        return this.getRemoteUri(digest, blob, servletRequest);
    }

    protected boolean isDirectDownload() {
        return this.directDownload;
    }

    protected URI getRemoteUri(String digest, ManagedBlob blob, HttpServletRequest servletRequest) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected String getProperty(String propertyName) {
        return this.getProperty(propertyName, null);
    }

    protected String getProperty(String propertyName, String defaultValue) {
        String propValue = this.properties.get(propertyName);
        if (StringUtils.isNotBlank((CharSequence)propValue)) {
            return propValue;
        }
        propValue = Framework.getProperty((String)this.getSystemPropertyName(propertyName));
        if (StringUtils.isNotBlank((CharSequence)propValue)) {
            return propValue;
        }
        return defaultValue;
    }

    protected int getIntProperty(String key) {
        String s = this.getProperty(key);
        int value = -1;
        if (!StringUtils.isBlank((CharSequence)s)) {
            try {
                value = Integer.parseInt(s.trim());
            }
            catch (NumberFormatException e) {
                log.error((Object)("Cannot parse " + key + ": " + s));
            }
        }
        return value;
    }

    protected boolean getBooleanProperty(String key) {
        return Boolean.parseBoolean(this.getProperty(key));
    }

    public String getSystemPropertyName(String propertyName) {
        return this.getSystemPropertyPrefix() + "." + propertyName;
    }

    protected String getContentTypeHeader(Blob blob) {
        String contentType = blob.getMimeType();
        String encoding = blob.getEncoding();
        if (contentType != null && !StringUtils.isBlank((CharSequence)encoding)) {
            int i = contentType.indexOf(59);
            if (i >= 0) {
                contentType = contentType.substring(0, i);
            }
            contentType = contentType + "; charset=" + encoding;
        }
        return contentType;
    }

    protected String getContentDispositionHeader(Blob blob, HttpServletRequest servletRequest) {
        if (servletRequest == null) {
            return RFC2231.encodeContentDisposition((String)blob.getFilename(), (boolean)false, null);
        }
        return DownloadHelper.getRFC2231ContentDisposition((HttpServletRequest)servletRequest, (String)blob.getFilename());
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

