/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.runtime.aws.NuxeoAWSCredentialsProvider;

public class S3Utils {
    public static final long NON_MULTIPART_COPY_MAX_SIZE = 0x140000000L;
    public static final long PART_SIZE = 0x500000L;

    private S3Utils() {
    }

    public static void processSlices(long slice, long length, SliceConsumer consumer) {
        if (slice <= 0L) {
            throw new IllegalArgumentException("Invalid slice length: " + slice);
        }
        long begin = 0L;
        int num = 0;
        while (begin < length) {
            long end = Math.min(begin + slice, length);
            consumer.accept(num, begin, end);
            begin += slice;
            ++num;
        }
    }

    public static ObjectMetadata copyFileMultipart(AmazonS3 amazonS3, ObjectMetadata objectMetadata, String sourceBucket, String sourceKey, String targetBucket, String targetKey, boolean deleteSource) {
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(sourceBucket, targetKey);
        InitiateMultipartUploadResult initiateMultipartUploadResult = amazonS3.initiateMultipartUpload(initiateMultipartUploadRequest);
        String uploadId = initiateMultipartUploadResult.getUploadId();
        long objectSize = objectMetadata.getContentLength();
        ArrayList<CopyPartResult> copyResponses = new ArrayList<CopyPartResult>();
        SliceConsumer partCopy = (num, begin, end) -> {
            CopyPartRequest copyRequest = new CopyPartRequest().withSourceBucketName(sourceBucket).withSourceKey(sourceKey).withDestinationBucketName(targetBucket).withDestinationKey(targetKey).withFirstByte(Long.valueOf(begin)).withLastByte(Long.valueOf(end - 1L)).withUploadId(uploadId).withPartNumber(num + 1);
            copyResponses.add(amazonS3.copyPart(copyRequest));
        };
        S3Utils.processSlices(0x500000L, objectSize, partCopy);
        CompleteMultipartUploadRequest completeRequest = new CompleteMultipartUploadRequest(targetBucket, targetKey, uploadId, S3Utils.responsesToETags(copyResponses));
        amazonS3.completeMultipartUpload(completeRequest);
        if (deleteSource) {
            amazonS3.deleteObject(sourceBucket, sourceKey);
        }
        return amazonS3.getObjectMetadata(targetBucket, targetKey);
    }

    protected static List<PartETag> responsesToETags(List<CopyPartResult> responses) {
        return responses.stream().map(response -> new PartETag(response.getPartNumber(), response.getETag())).collect(Collectors.toList());
    }

    public static ObjectMetadata copyFile(AmazonS3 amazonS3, ObjectMetadata objectMetadata, String sourceBucket, String sourceKey, String targetBucket, String targetKey, boolean deleteSource) {
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(sourceBucket, sourceKey, targetBucket, targetKey);
        amazonS3.copyObject(copyObjectRequest);
        if (deleteSource) {
            amazonS3.deleteObject(sourceBucket, sourceKey);
        }
        return amazonS3.getObjectMetadata(targetBucket, targetKey);
    }

    public static AWSCredentialsProvider getAWSCredentialsProvider(String accessKeyId, String secretKey, String sessionToken) {
        if (StringUtils.isNotBlank((CharSequence)accessKeyId) && StringUtils.isNotBlank((CharSequence)secretKey)) {
            if (StringUtils.isNotBlank((CharSequence)sessionToken)) {
                return new AWSStaticCredentialsProvider((AWSCredentials)new BasicSessionCredentials(accessKeyId, secretKey, sessionToken));
            }
            return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKeyId, secretKey));
        }
        return NuxeoAWSCredentialsProvider.getInstance();
    }

    @FunctionalInterface
    public static interface SliceConsumer {
        public void accept(int var1, long var2, long var4);
    }
}

