/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.executor.jaxrs;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.importer.base.ImporterRunner;
import org.nuxeo.ecm.platform.importer.executor.AbstractImporterExecutor;
import org.nuxeo.ecm.platform.importer.executor.jaxrs.AbstractJaxRSImporterExecutor;
import org.nuxeo.ecm.platform.importer.service.DefaultImporterService;
import org.nuxeo.runtime.api.Framework;

@Path(value="fileImporter")
public class HttpFileImporterExecutor
extends AbstractJaxRSImporterExecutor {
    private static final Log log = LogFactory.getLog(HttpFileImporterExecutor.class);

    protected Log getJavaLogger() {
        return log;
    }

    @GET
    @Path(value="run")
    @Produces(value={"text/plain; charset=UTF-8"})
    public String run(@QueryParam(value="leafType") String leafType, @QueryParam(value="folderishType") String folderishType, @QueryParam(value="inputPath") String inputPath, @QueryParam(value="targetPath") String targetPath, @QueryParam(value="skipRootContainerCreation") Boolean skipRootContainerCreation, @QueryParam(value="batchSize") Integer batchSize, @QueryParam(value="nbThreads") Integer nbThreads, @QueryParam(value="interactive") Boolean interactive, @QueryParam(value="transactionTimeout") Integer transactionTimeout) {
        if (inputPath == null || targetPath == null) {
            return "Can not import, missing " + (inputPath == null ? "inputPath" : "targetPath");
        }
        if (skipRootContainerCreation == null) {
            skipRootContainerCreation = false;
        }
        if (batchSize == null) {
            batchSize = 5;
        }
        if (nbThreads == null) {
            nbThreads = 5;
        }
        if (interactive == null) {
            interactive = false;
        }
        if (transactionTimeout == null) {
            transactionTimeout = 0;
        }
        DefaultImporterService defaultImporterService = (DefaultImporterService)Framework.getService(DefaultImporterService.class);
        defaultImporterService.setTransactionTimeout(transactionTimeout.intValue());
        if (leafType != null || folderishType != null) {
            log.info((Object)"Importing with the specified doc types");
            return defaultImporterService.importDocuments((AbstractImporterExecutor)this, leafType, folderishType, targetPath, inputPath, skipRootContainerCreation.booleanValue(), batchSize.intValue(), nbThreads.intValue(), interactive.booleanValue());
        }
        log.info((Object)"Importing with the deafult doc types");
        return defaultImporterService.importDocuments((AbstractImporterExecutor)this, targetPath, inputPath, skipRootContainerCreation.booleanValue(), batchSize.intValue(), nbThreads.intValue(), interactive.booleanValue());
    }

    public String run(ImporterRunner runner, Boolean interactive) {
        return this.doRun(runner, interactive);
    }
}

