/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.blob;

import java.io.IOException;
import java.util.Map;
import org.nuxeo.ecm.core.blob.AbstractBlobStoreConfiguration;
import org.nuxeo.ecm.core.blob.CachingConfiguration;
import org.nuxeo.ecm.core.blob.DigestConfiguration;

public abstract class CloudBlobStoreConfiguration
extends AbstractBlobStoreConfiguration {
    public static final String DIRECTDOWNLOAD_PROPERTY = "directdownload";
    public static final String DEFAULT_DIRECTDOWNLOAD = "false";
    public static final String DIRECTDOWNLOAD_EXPIRE_PROPERTY = "directdownload.expire";
    public static final long DEFAULT_DIRECTDOWNLOAD_EXPIRE = 3600L;
    public static final String DIGEST_ALGORITHM_PROPERTY = "digest";
    public final DigestConfiguration digestConfiguration;
    public final CachingConfiguration cachingConfiguration;
    public final boolean directDownload;
    public final long directDownloadExpire;

    public CloudBlobStoreConfiguration(String systemPropertyPrefix, Map<String, String> properties) throws IOException {
        super(systemPropertyPrefix, properties);
        this.digestConfiguration = new DigestConfiguration(systemPropertyPrefix, properties);
        this.cachingConfiguration = new CachingConfiguration(systemPropertyPrefix, properties);
        this.directDownload = this.parseDirectDownload();
        this.directDownloadExpire = this.parseDirectDownloadExpire();
    }

    protected boolean parseDirectDownload() {
        return Boolean.parseBoolean(this.getProperty(DIRECTDOWNLOAD_PROPERTY, DEFAULT_DIRECTDOWNLOAD));
    }

    protected long parseDirectDownloadExpire() {
        long expire = this.getLongProperty(DIRECTDOWNLOAD_EXPIRE_PROPERTY);
        if (expire < 0L) {
            expire = 3600L;
        }
        return expire;
    }
}

