/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.log;

import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.nuxeo.ecm.platform.importer.log.BasicLogger;

public class BufferredLogger
extends BasicLogger {
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected static int DEFAULT_LOG_BUFFER_LENGTH = 50;
    protected Integer bufferSize = null;
    protected LinkedList<String> logStack = new LinkedList();

    public BufferredLogger(Log javaLogger) {
        super(javaLogger);
    }

    public BufferredLogger(Log javaLogger, int bufferSize) {
        super(javaLogger);
        this.bufferSize = bufferSize;
    }

    protected int getMaxStackLen() {
        if (this.bufferSize == null) {
            this.bufferSize = DEFAULT_LOG_BUFFER_LENGTH;
        }
        return this.bufferSize;
    }

    protected void logInStack(String level, String message) {
        if (!this.bufferActive) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.logStack.add(level + " : " + message);
            if (this.logStack.size() > this.getMaxStackLen()) {
                this.logStack.remove();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLoggerBuffer(String sep) {
        StringBuilder sb = new StringBuilder();
        this.lock.readLock().lock();
        try {
            for (String line : this.logStack) {
                sb.append(line);
                sb.append(sep);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void info(String message) {
        super.info(message);
        if (this.bufferActive) {
            this.logInStack("INFO", message);
        }
    }

    @Override
    public void warn(String message) {
        super.warn(message);
        if (this.bufferActive) {
            this.logInStack("WARN", message);
        }
    }

    @Override
    public void debug(String message) {
        super.debug(message);
        if (this.bufferActive) {
            this.logInStack("DEBUG", message);
        }
    }

    @Override
    public void debug(String message, Throwable t) {
        super.debug(message, t);
        if (this.bufferActive) {
            this.logInStack("DEBUG", message);
            this.logInStack("=>ERR", t.getClass().getSimpleName() + ":" + t.getMessage());
        }
    }

    @Override
    public void error(String message) {
        super.error(message);
        if (this.bufferActive) {
            this.logInStack("ERROR", message);
        }
    }

    @Override
    public void error(String message, Throwable t) {
        super.error(message, t);
        if (this.bufferActive) {
            this.logInStack("ERROR", message);
            this.logInStack("=>ERR", t.getClass().getSimpleName() + ":" + t.getMessage());
        }
    }
}

